% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_special_trx.R
\name{plot_special_trx}
\alias{plot_special_trx}
\alias{plot_utilization_rates}
\title{Additional plotting functions for transaction studies}
\usage{
plot_utilization_rates(object, ...)
}
\arguments{
\item{object}{An object of class \code{trx_df} created by the function
\code{\link[=trx_stats]{trx_stats()}}.}

\item{...}{Additional arguments passed to \code{\link[=autoplot.trx_df]{autoplot.trx_df()}}.}
}
\value{
a \code{ggplot} object
}
\description{
These functions create additional experience study plots that are not
available or difficult to produce using the \code{\link[=autoplot.trx_df]{autoplot.trx_df()}} function.
}
\details{
\code{\link[=plot_utilization_rates]{plot_utilization_rates()}} - Create a plot of transaction frequency and
severity. Frequency is represented by utilization rates (\code{trx_util}).
Severity is represented by transaction amounts as a percentage of one or
more other columns in the data (\verb{\{*\}_w_trx}). All severity series begin with
the prefix "pct_of_" and end with the suffix "_w_trx". The suffix refers to
the fact that the denominator only includes records with non-zero
transactions. Severity series are based on column names passed to the
\code{percent_of} argument in \code{\link[=trx_stats]{trx_stats()}}. If no "percentage of" columns exist
in \code{object}, this function will only plot utilization rates.
}
\examples{

study_py <- expose_py(census_dat, "2019-12-31",
                      target_status = "Surrender") |>
  add_transactions(withdrawals) |>
  left_join(account_vals, by = c("pol_num", "pol_date_yr"))

trx_res <- study_py |> group_by(pol_yr) |>
  trx_stats(percent_of = "av_anniv", combine_trx = TRUE)

plot_utilization_rates(trx_res)

}
\seealso{
\code{\link[=autoplot.trx_df]{autoplot.trx_df()}}
}
