% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{summary.afttest}
\alias{summary.afttest}
\title{summary.afttest}
\usage{
\method{summary}{afttest}(object, ...)
}
\arguments{
\item{object}{is a \code{afttest} fit.}

\item{...}{other options.}
}
\value{
\code{summary.afttest} returns a summary of a \code{afttest} fit:
}
\description{
summary.afttest
}
\examples{
## Simulate data from an AFT model
library(afttest)
datgen <- function(n = 100) {
  z1 <- rbinom(n, 1, 0.5)
  z2 <- rnorm(n)
  e <- rnorm(n)
  tt <- exp(2 + z1 + z2 + e)
  cen <- runif(n, 0, 100)
  data.frame(Time = pmin(tt, cen), status = 1 * (tt < cen),
             z1 = z1, z2 = z2, id = 1:n)
}
set.seed(0)
simdata <- datgen(n = 20)
result <- afttest(Surv(Time, status) ~ z1 + z2, data = simdata, npath = 200, 
                  testType = "link", estMethod = "rr", 
                  eqType = "ns", npathsave = 50)
print(result)
summary(result)
# plot(result)
}
