# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name Rho Koenker 
#'
#' @param x Numeric vector
#' @param tau Numeric scalar, percentile (between 0 and 1)
#'
#' @return A numeric vector with the Koenker rho function applied element-wise.
#' @keywords internal
#' @noRd
rho_koenker <- function(x, tau) {
    .Call(`_alqrfe_rho_koenker`, x, tau)
}

#' @name Loss quantile regression
#'
#' @param beta initial values
#' @param x design matrix
#' @param y vector output
#' @param tau percentile
#' @param N sample size
#' @param d columns of x
#'
#' @return Scalar quantile regression loss value.
#' @keywords internal
#' @noRd
loss_qr <- function(beta, x, y, tau, N, d) {
    .Call(`_alqrfe_loss_qr`, beta, x, y, tau, N, d)
}

#' @name Loss quantile regression with fixed effects
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z
#'
#' @return Scalar quantile regression loss value.
#' @keywords internal
#' @noRd
loss_qrfe <- function(theta, x, y, z, tau, n, d, mm) {
    .Call(`_alqrfe_loss_qrfe`, theta, x, y, z, tau, n, d, mm)
}

#' @name Loss lasso quantile regression with fixed effects
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z
#' @param lambda constriction parameter
#'
#' @return Scalar loss value including quantile loss and L1 penalty on beta.
#' @keywords internal
#' @noRd
loss_lqr <- function(theta, x, y, z, tau, n, d, mm, lambda) {
    .Call(`_alqrfe_loss_lqr`, theta, x, y, z, tau, n, d, mm, lambda)
}

#' @title Loss Function for Adaptive Lasso Quantile Regression with Fixed Effects
#'
#' @description Computes the penalized quantile regression loss with adaptive lasso penalty
#' and fixed effects under a sum-to-zero constraint.
#'
#' @param theta Numeric vector. Parameters: beta (length d) and alpha[1:(mm-1)] (length mm - 1).
#' @param x Numeric matrix. Covariate design matrix (n x d).
#' @param y Numeric vector. Response vector (length n).
#' @param z Numeric matrix. Incidence matrix for fixed effects (n x mm).
#' @param tau Numeric scalar. Quantile level.
#' @param n Integer. Sample size.
#' @param d Integer. Number of covariates (columns in x).
#' @param mm Integer. Number of fixed effects (columns in z).
#' @param lambda Numeric. Lasso penalty parameter.
#' @param w Numeric vector. Adaptive lasso weights for all parameters (length d + mm).
#'
#' @return Loss scalar (quantile loss + adaptive lasso penalty)
#' @keywords internal
#' @noRd
loss_alqr <- function(theta, x, y, z, tau, n, d, mm, lambda, w) {
    .Call(`_alqrfe_loss_alqr`, theta, x, y, z, tau, n, d, mm, lambda, w)
}

