% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-read.R
\name{set_layer_aliases}
\alias{set_layer_aliases}
\title{Set column labels or names based FeatureLayer or Table data frame field
aliases}
\usage{
set_layer_aliases(
  .data,
  .layer,
  name_repair = "unique",
  alias = c("replace", "label"),
  call = rlang::caller_env()
)
}
\arguments{
\item{.data}{A data frame returned by \code{arc_select()} or \code{arc_read()}.}

\item{.layer}{A Table or FeatureLayer object. Required.}

\item{name_repair}{Default \code{"unique"}. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for
details. If \code{name_repair = NULL} and \code{alias = "replace"} may include
invalid names.}

\item{alias}{Use of field alias values. Defaults to \code{"replace"}. There are two
options:
\itemize{
\item \code{"label"}: field alias values are assigned as a label attribute for each field.
\item \code{"replace"}: field alias values replace existing column names.
}}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A data.frame. When \code{alias = "replace"}, the column names are modified.
When \code{alias = "label"} each column has a new \code{label} attribute.
}
\description{
\code{\link[=set_layer_aliases]{set_layer_aliases()}} can replace or label column names based on the the
field aliases from a corresponding \code{Table} or \code{FeatureLayer} object created
with \code{arc_open()}. Optionally repair names using \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
}
\examples{
furl <- paste0(
  "https://services.arcgis.com/P3ePLMYs2RVChkJx/ArcGIS/",
  "rest/services/USA_Counties_Generalized_Boundaries/FeatureServer/0"
)

# open the feature service
flayer <- arc_open(furl)

# select first five rows
five_counties <- arc_select(flayer, n_max = 5)

# add aliases
with_aliases <- set_layer_aliases(five_counties, flayer)

# preview the new names
str(with_aliases, give.attr = FALSE)
}
