% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_ssvd-constructors.R
\name{ssvd}
\alias{ssvd}
\title{Create Object to Hold Data from a Scaled SVD}
\usage{
ssvd(data)
}
\arguments{
\item{data}{A data frame. See Details for description.}
}
\value{
An object of class \code{"bage_ssvd"}.
}
\description{
Create an object of class \code{"bage_ssvd"} to
hold results from a scaled \link[base:svd]{Singular Value Decomposition}
(SVD) with \code{n_comp} components.
}
\details{
\code{data} has the following columns:
\itemize{
\item \code{version} Vintage of data
\item \code{type} Type of decomposition. Choices are "total",
"joint", and "indep".
\item \code{labels_age} Age labels for individual rows of
matrices within \code{matrix} and individual elements
of vectors within \code{offset}.
\item \code{labels_sexgender} Sex/gender labels for individual rows of
matrices within \code{matrix} and individual elements
of vectors within \code{offset}, or \code{NULL}.
\code{NULL} when \code{sexgender} is \code{"total"}, since in
this case results average across sexes/genders.
\item \code{matrix} List column of sparse matrices.
Must have rownames.
Must not have NAs. When \code{type} is \code{"total"} or \code{"joint"},
each matrix has \code{n_comp} columns. When \code{"type"} is \code{"indep"},
each matrix has \code{2 * n_comp} columns.
\item \code{offset} List column of vectors.
Must have names, which
are identical to the rownames of the corresponding
element of \code{matrix}.
}

\code{data} would normally be constructed using functions
in package \href{https://bayesiandemography.github.io/bssvd/}{bssvd}.
}
\examples{
ssvd(data_wmd)
}
\seealso{
\itemize{
\item \link[=svds]{Scaled SVDs} Overview of scaled SVDs
implemented in \pkg{bage}
\item \code{\link[=SVD]{SVD()}} Prior based on scaled SVD
}
}
