#'
#' Philippine Tropical Cyclones Data
#'
#' The Philippines frequently experiences tropical cyclones (called 'bagyo' in
#' the Filipino language) because of its geographical position. These cyclones
#' typically bring heavy rainfall, leading to widespread flooding, as well as
#' strong winds that cause significant damage to human life, crops, and
#' property. Data on cyclones are collected and curated by the Philippine
#' Atmospheric, Geophysical, and Astronomical Services Administration (PAGASA)
#' and made available through its website. This package contains Philippine
#' tropical cyclones data in a machine-readable format. It is hoped that this
#' data package provides an interesting and unique dataset for data exploration
#' and visualisation as an adjunct to the traditional `iris` dataset and to the
#' current `palmerpenguins` dataset.
#'
#' @docType package
#' @keywords internal
#' @name bagyo
#'
"_PACKAGE"
