% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_pmp.R
\name{model_pmp}
\alias{model_pmp}
\title{Graphs of the prior and posterior model probabilities for the best individual models}
\arguments{
\item{bma_list}{bma_list object (the result of the bma function)}

\item{top}{The number of the best model to be placed on the graphs}
}
\value{
A list with three graphs with prior and posterior model probabilities for individual models:\cr
\enumerate{
\item The results with binomial model prior (based on PMP - posterior model probability) \cr
\item The results with binomial-beta model prior (based on PMP - posterior model probability) \cr
\item On graph combining the aforementioned graphs
}
}
\description{
This function draws four graphs of prior and posterior model probabilities for the best individual models: \cr
a) The results with binomial model prior (based on PMP - posterior model probability) \cr
b) The results with binomial-beta model prior (based on PMP - posterior model probability) \cr
Models on the graph are ordered according to their posterior model probability.
}
\examples{
\donttest{
library(magrittr)

data_prepared <- bdsm::economic_growth[, 1:6] \%>\%
  bdsm::feature_standardization(
    excluded_cols = c(country, year, gdp)
  ) \%>\%
  bdsm::feature_standardization(
    group_by_col  = year,
    excluded_cols = country,
    scale         = FALSE
  )

bma_results <- bma(
  model_space = bdsm::small_model_space,
  df          = data_prepared,
  round       = 3,
  dilution    = 0
)

model_graphs <- model_pmp(bma_results, top = 16)
}

}
