% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R
\name{svd_robust_R}
\alias{svd_robust_R}
\title{Iteratively reweighted singular value decomposition}
\usage{
svd_robust_R(
  x,
  ncomp,
  max_iter = 25L,
  tol = sqrt(.Machine$double.eps),
  huber_k = 1.345
)
}
\arguments{
\item{x}{Numeric matrix for which the decomposition should be computed.}

\item{ncomp}{Number of leading components to retain.}

\item{max_iter}{Maximum number of reweighting iterations.}

\item{tol}{Convergence tolerance applied to successive changes in the row
weights and singular values.}

\item{huber_k}{Tuning constant controlling the aggressiveness of the Huber
weight function. Larger values down-weight fewer observations.}
}
\value{
A list containing the left and right singular vectors (\code{u} and \code{v}),
the singular values (\code{d}), the final row weights (\code{weights}), and the number
of iterations required for convergence (\code{iterations}). The structure mirrors
base R's \code{\link[base:svd]{base::svd()}} output with additional metadata.
}
\description{
Internal helper used by \code{\link[=pca_robust]{pca_robust()}} to compute a singular value
decomposition that is less sensitive to individual rows with extreme values.
The routine alternates between computing the SVD of a row-weighted matrix and
updating the weights via a Huber-type scheme based on the reconstruction
residuals.
}
