% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_raw.R
\name{bc.raw}
\alias{bc.raw}
\alias{bc.raw,ANY-method}
\title{Broadcasted Operations that Take Raw Arrays and Return Raw Arrays}
\usage{
bc.raw(x, y, op, ...)

\S4method{bc.raw}{ANY}(x, y, op)
}
\arguments{
\item{x, y}{conformable vectors/arrays of type raw.}

\item{op}{a single string, giving the operator. \cr
Supported operators: ==, !=, <, >, <=, >=, pmin, pmax, diff. \cr
The relational operators work the same as in \link{bc.rel},
but with the following difference: \cr
a \code{TRUE} result is replaced with \code{01},
and a \code{FALSE} result is replaced with \code{00}. \cr
The "diff" operator performs the byte equivalent of \code{abs(x - y)}.}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
\code{bc.raw()} \bold{always} returns an array of type \code{raw}. \cr
For the relational operators,
\code{01} codes for \code{TRUE} results,
and \code{00} codes for \code{FALSE} results. \cr
\cr
}
\description{
The \code{bc.raw()} function
performs broadcasted operations
on arrays of type \code{raw}, and the return type is \bold{always} \code{raw}. \cr
\cr
For bit-wise operations, use \link{bc.bit}. \cr
For relational operations with logical (\code{TRUE}/\code{FALSE}/\code{NA}) results, use \link{bc.rel}. \cr
\cr
}
\examples{

x <- array(
  sample(as.raw(1:100)), c(5, 3, 2)
)
y <- array(
  sample(as.raw(1:100)), c(5, 1, 1)
)

cond <- bc.raw(x, y, "!=")
print(cond)

bc_ifelse(cond, yes = x, no = y)


}
\seealso{
\link{broadcast_operators}
}
