% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR.R
\docType{package}
\name{bruceR-package}
\alias{bruceR}
\alias{bruceR-package}
\title{bruceR: \strong{BR}oadly \strong{U}seful \strong{C}onvenient and \strong{E}fficient \strong{R} functions}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Broadly useful convenient and efficient R functions that bring users concise and elegant R data analyses. This package includes easy-to-use functions for (1) basic R programming (e.g., set working directory to the path of currently opened file; import/export data from/to files in any format; print tables to Microsoft Word); (2) multivariate computation (e.g., compute scale sums/means/... with reverse scoring); (3) reliability analyses and factor analyses; (4) descriptive statistics and correlation analyses; (5) t-test, multi-factor analysis of variance (ANOVA), simple-effect analysis, and post-hoc multiple comparison; (6) tidy report of statistical models (to R Console and Microsoft Word); (7) mediation and moderation analyses (PROCESS); and (8) additional toolbox for statistics and graphics.
}
\section{Main Functions in \code{bruceR}}{
\subsection{1. Basic R Programming}{
\itemize{
\item \code{\link[=set.wd]{set.wd()}} (alias: \code{\link[=set_wd]{set_wd()}})
\item \code{\link[=import]{import()}}
\item \code{\link[=export]{export()}}
\item \code{\link[=cc]{cc()}}
\item \code{\link[=pkg_depend]{pkg_depend()}}
\item \code{\link[=formatF]{formatF()}}
\item \code{\link[=formatN]{formatN()}}
\item \code{\link[=print_table]{print_table()}}
\item \code{\link[=Print]{Print()}}
\item \code{\link[=Glue]{Glue()}}
\item \code{\link[=Run]{Run()}}
\item \code{\link[=\%^\%]{\%^\%}}
\item \code{\link[=\%notin\%]{\%notin\%}}
\item \code{\link[=\%allin\%]{\%allin\%}}
\item \code{\link[=\%anyin\%]{\%anyin\%}}
\item \code{\link[=\%nonein\%]{\%nonein\%}}
\item \code{\link[=\%partin\%]{\%partin\%}}
}
}

\subsection{2. Multivariate Computation}{
\itemize{
\item \code{\link[=add]{add()}}
\item \code{\link[=added]{added()}}
\item \code{\link[=.sum]{.sum()}}
\item \code{\link[=.mean]{.mean()}}
\item \code{\link[=SUM]{SUM()}}
\item \code{\link[=MEAN]{MEAN()}}
\item \code{\link[=STD]{STD()}}
\item \code{\link[=MODE]{MODE()}}
\item \code{\link[=COUNT]{COUNT()}}
\item \code{\link[=CONSEC]{CONSEC()}}
\item \code{\link[=RECODE]{RECODE()}}
\item \code{\link[=RESCALE]{RESCALE()}}
\item \code{\link[=LOOKUP]{LOOKUP()}}
}
}

\subsection{3. Reliability and Factor Analyses}{
\itemize{
\item \code{\link[=Alpha]{Alpha()}}
\item \code{\link[=EFA]{EFA()}}
\item \code{\link[=PCA]{PCA()}}
\item \code{\link[=CFA]{CFA()}}
}
}

\subsection{4. Descriptive Statistics and Correlation Analyses}{
\itemize{
\item \code{\link[=Describe]{Describe()}}
\item \code{\link[=Freq]{Freq()}}
\item \code{\link[=Corr]{Corr()}}
\item \code{\link[=cor_diff]{cor_diff()}}
\item \code{\link[=cor_multilevel]{cor_multilevel()}}
}
}

\subsection{5. T-Test, Multi-Factor ANOVA, Simple-Effect Analysis, and Post-Hoc Multiple Comparison}{
\itemize{
\item \code{\link[=TTEST]{TTEST()}}
\item \code{\link[=MANOVA]{MANOVA()}}
\item \code{\link[=EMMEANS]{EMMEANS()}}
}
}

\subsection{6. Tidy Report of Regression Models}{
\itemize{
\item \code{\link[=model_summary]{model_summary()}}
\item \code{\link[=lavaan_summary]{lavaan_summary()}}
\item \code{\link[=GLM_summary]{GLM_summary()}}
\item \code{\link[=HLM_summary]{HLM_summary()}}
\item \code{\link[=HLM_ICC_rWG]{HLM_ICC_rWG()}}
\item \code{\link[=regress]{regress()}}
}
}

\subsection{7. Mediation and Moderation Analyses}{
\itemize{
\item \code{\link[=PROCESS]{PROCESS()}}
\item \code{\link[=med_summary]{med_summary()}}
\item \code{\link[=lavaan_summary]{lavaan_summary()}}
}
}

\subsection{8. Additional Toolbox for Statistics and Graphics}{
\itemize{
\item \code{\link[=grand_mean_center]{grand_mean_center()}}
\item \code{\link[=group_mean_center]{group_mean_center()}}
\item \code{\link[=ccf_plot]{ccf_plot()}}
\item \code{\link[=granger_test]{granger_test()}}
\item \code{\link[=granger_causality]{granger_causality()}}
\item \code{\link[=theme_bruce]{theme_bruce()}}
\item \code{\link[=show_colors]{show_colors()}}
}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://psychbruce.github.io/bruceR/}
  \item Report bugs at \url{https://github.com/psychbruce/bruceR/issues}
}

}
\author{
\strong{Maintainer}: Han Wu Shuang Bao \email{baohws@foxmail.com} (\href{https://orcid.org/0000-0003-3043-710X}{ORCID})

}
