% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PosteriorRegimePr}
\alias{plot.PosteriorRegimePr}
\title{Plots estimated regime probabilities}
\usage{
\method{plot}{PosteriorRegimePr}(
  x,
  probability = 0.9,
  col = "#ff69b4",
  main,
  xlab,
  mar.multi = c(1, 4.6, 0, 2.1),
  oma.multi = c(6, 0, 5, 0),
  ...
)
}
\arguments{
\item{x}{an object of class PosteriorRegimePr obtained using the
\code{compute_regime_probabilities()} function containing posterior draws of 
regime probabilities.}

\item{probability}{a parameter determining the interval to be plotted. The 
interval stretches from the \code{0.5 * (1 - probability)} to 
\code{1 - 0.5 * (1 - probability)} percentile of the posterior distribution.}

\item{col}{a colour of the plot line and the ribbon}

\item{main}{an alternative main title for the plot}

\item{xlab}{an alternative x-axis label for the plot}

\item{mar.multi}{the default \code{mar} argument setting in \code{graphics::par}. Modify with care!}

\item{oma.multi}{the default \code{oma} argument setting in \code{graphics::par}. Modify with care!}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
Plots of estimated regime probabilities of Markov-switching 
heteroskedasticity or allocations of normal-mixture components including their 
median and percentiles.
}
\examples{
data(us_fiscal_lsuw)                                  # upload data
set.seed(123)                                         # set seed
specification  = specify_bsvar_msh$new(us_fiscal_lsuw)# specify model
burn_in        = estimate(specification, 10)          # run the burn-in
posterior      = estimate(burn_in, 20, thin = 1)      # estimate the model

# compute regime probabilities
rp             = compute_regime_probabilities(posterior)
plot(rp)                                              # plot

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_msh$new() |>
  estimate(S = 10) |> 
  estimate(S = 20, thin = 1) |> 
  compute_regime_probabilities() |>
  plot()

}
\seealso{
\code{\link{compute_regime_probabilities}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
