% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PosteriorSigma}
\alias{plot.PosteriorSigma}
\title{Plots structural shocks' conditional standard deviations}
\usage{
\method{plot}{PosteriorSigma}(
  x,
  probability = 0.9,
  shock_names,
  col = "#ff69b4",
  main,
  xlab,
  mar.multi = c(1, 4.6, 0, 2.1),
  oma.multi = c(6, 0, 5, 0),
  ...
)
}
\arguments{
\item{x}{an object of class PosteriorSigma obtained using the
\code{compute_conditional_sd()} function containing posterior draws of 
conditional standard deviations of structural shocks.}

\item{probability}{a parameter determining the interval to be plotted. The 
interval stretches from the \code{0.5 * (1 - probability)} to 
\code{1 - 0.5 * (1 - probability)} percentile of the posterior distribution.}

\item{shock_names}{a vector of length \code{N} containing names of the structural shocks.}

\item{col}{a colour of the plot line and the ribbon}

\item{main}{an alternative main title for the plot}

\item{xlab}{an alternative x-axis label for the plot}

\item{mar.multi}{the default \code{mar} argument setting in \code{graphics::par}. Modify with care!}

\item{oma.multi}{the default \code{oma} argument setting in \code{graphics::par}. Modify with care!}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
Plots of structural shocks' conditional standard deviations 
including their median and percentiles.
}
\examples{
data(us_fiscal_lsuw)                                  # upload data
set.seed(123)                                         # set seed
specification  = specify_bsvar_sv$new(us_fiscal_lsuw) # specify model
burn_in        = estimate(specification, 5)           # run the burn-in
posterior      = estimate(burn_in, 5)                 # estimate the model

# compute structural shocks' conditional standard deviations
sigma          = compute_conditional_sd(posterior)
plot(sigma)                                            # plot conditional sds

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_sv$new(p = 1) |>
  estimate(S = 5) |> 
  estimate(S = 5) |> 
  compute_conditional_sd() |>
  plot()

}
\seealso{
\code{\link{compute_conditional_sd}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
