% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-files-code-search.R
\name{btw_tool_files_code_search}
\alias{btw_tool_files_code_search}
\title{Tool: Code Search in Project}
\usage{
btw_tool_files_code_search(
  term,
  limit = 100,
  case_sensitive = TRUE,
  use_regex = FALSE,
  show_lines = FALSE,
  `_intent` = ""
)
}
\arguments{
\item{term}{The term to search for in the code files.}

\item{limit}{Maximum number of matching lines to return (between 1 and 1000,
default 100).}

\item{case_sensitive}{Whether the search should be case-sensitive (default is
\code{FALSE}).}

\item{use_regex}{Whether to interpret the search term as a regular expression
(default is \code{FALSE}).}

\item{show_lines}{Whether to show the matching lines in the results. Defaults
to \code{FALSE}, which means only the file names and count of matching lines
are returned.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a tool result with a data frame of search results, with
columns for \code{filename}, \code{size}, \code{last_modified}, \code{content} and \code{line}.
}
\description{
Search through code files in the project directory for specific terms.
}
\details{
\subsection{Options}{

You can configure which file extensions are included and which paths are
excluded from code search by using two options:
\itemize{
\item \code{btw.files_code_search.extensions}: A character vector of file extensions
to search in (default includes R, Python, JavaScript, TypeScript, Markdown,
SCSS, and CSS files).
\item \code{btw.files_code_search.exclusions}: A character vector of gitignore-style
patterns to exclude paths and directories from the search. The default
value includes a set of common version control, IDE, and cache folders.
}

Alternatively, you can also set these options in your \code{btw.md} file under the
\code{options} section, like this:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{---
client:
  provider: anthropic
tools: [files_code_search]
options:
  files_code_search:
    extensions: ["R", "Rmd", "py", "qmd"]
    exclusions: ["DEFAULT", ".quarto/"]
---
}\if{html}{\out{</div>}}

Include \code{"DEFAULT"} in the \code{exclusions} option to use btw's default
exclusions, which cover common directories like \verb{.git/}, \verb{.vscode/}.

If the \pkg{gert} package is installed and the project is a Git repository,
the tool will also respect the \code{.gitignore} file and exclude any ignored
paths, regardless of the \code{btw.files_code_search.exclusions} option.
}
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
withr::with_tempdir({
  writeLines(state.name[1:25], "state_names_1.md")
  writeLines(state.name[26:50], "state_names_2.md")

  tools <- btw_tools("files_code_search")
  tools$btw_tool_files_code_search(
    term = "kentucky",
    case_sensitive = FALSE,
    show_lines = TRUE
  )
})
\dontshow{\}) # examplesIf}
}
\seealso{
Other files tools: 
\code{\link{btw_tool_files_list_files}()},
\code{\link{btw_tool_files_read_text_file}()},
\code{\link{btw_tool_files_write_text_file}()}
}
\concept{files tools}
