% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-run.R
\name{btw_tool_run_r}
\alias{btw_tool_run_r}
\title{Tool: Run R code}
\usage{
btw_tool_run_r(code, `_intent` = "")
}
\arguments{
\item{code}{A character string containing R code to run.}

\item{_intent}{Intent description (automatically added by ellmer).}
}
\value{
A list of ellmer Content objects:
\itemize{
\item \code{ContentText}: visible return values and text output
\item \code{ContentMessage}: messages from \code{message()}
\item \code{ContentWarning}: warnings from \code{warning()}
\item \code{ContentError}: errors from \code{stop()}
\item \code{ContentImageInline}: plots created during execution
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This tool runs R code and returns results as a list of \code{\link[ellmer:Content]{ellmer::Content()}}
objects. It captures text output, plots, messages, warnings, and errors. Code
execution stops on the first error, returning all results up to that point.
}
\details{
\subsection{Configuration Options}{

The behavior of the \code{btw_tool_run_r} tool can be customized using the
following R options:
\itemize{
\item \code{btw.run_r.graphics_device}: A function that creates a graphics device used
for rendering plots. By default, it uses \code{ragg::agg_png()} if the \code{ragg}
package is installed, otherwise it falls back to \code{grDevices::png()}.
\item \code{btw.run_r.plot_aspect_ratio}: Aspect ratio for plots created during code
execution. Can be a character string of the form \code{"w:h"} (e.g., \code{"16:9"})
or a numeric value representing width/height (e.g., \code{16/9}). Default is
\code{"3:2"}.
\item \code{btw.run_r.plot_size}: Integer pixel size for the longest side of plots.
Default is \code{768L}. This image size was selected to match \href{https://platform.openai.com/docs/guides/images-vision?api-mode=responses}{OpenAI's image resizing rules},
where images are resized such that the largest size is 768px. Another
common choice is 512px. Larger images may be used but will result in
increased token sizes.
\item \code{btw.run_r.enabled}: Logical flag to enable or disable the tool globally.
}

These values can be set using \code{\link[=options]{options()}} in your R session or \code{.Rprofile} or
in a \link[=use_btw_md]{btw.md file} under the \code{options} section.

\if{html}{\out{<div class="sourceCode md">}}\preformatted{---
options:
 run_r:
   enabled: true
   plot_aspect_ratio: "16:9"
   plot_size: 512
---
}\if{html}{\out{</div>}}
}
}
\section{Security Considerations}{

Executing arbitrary R code can pose significant security risks, especially
in shared or multi-user environments. Furthermore, neither \pkg{shinychat}
(as of v0.4.0) or nor \pkg{ellmer} (as of v0.4.0) provide a mechanism to
review and reject the code before execution. Even more, the code is executed
in the global environment and does not have any sandboxing or R code
limitations applied.

It is your responsibility to ensure that you are taking appropriate measures
to reduce the risk of the LLM writing arbitrary code. Most often, this means
not prompting the model to take large or potentially destructive actions.
At this time, we do not recommend that you enable this tool in a publicly-
available environment without strong safeguards in place.

That said, this tool is very powerful and can greatly enhance the
capabilities of your btw chatbots. Please use it responsibly! If you'd like
to enable the tool, please read the instructions below.
}

\section{Enabling this tool}{

This tool is not enabled by default in \code{\link[=btw_tools]{btw_tools()}}, \code{\link[=btw_app]{btw_app()}} or
\code{\link[=btw_client]{btw_client()}}. To enable the function, you have a few options:
\enumerate{
\item Set the \code{btw.run_r.enabled} option to \code{TRUE} in your R session, or in your
\code{.Rprofile} file to enable it globally.
\item Set the \code{BTW_RUN_R_ENABLED} environment variable to \code{true} in your
\code{.Renviron} file or your system environment.
\item Explicitly include the tool when calling \code{btw_tools("run")} (unless the
above options disable it).
}

In your \link[=use_btw_md]{btw.md file}, you can explicitly enable the tool by
naming it in the tools option

\if{html}{\out{<div class="sourceCode md">}}\preformatted{---
tools:
  - run_r
---
}\if{html}{\out{</div>}}

or you can enable the tool by setting the \code{btw.run_r.enabled} option from the
\code{options} list in \code{btw.md} (this approach is useful if you've globally
disabled the tool but want to enable it for a specific btw chat):

\if{html}{\out{<div class="sourceCode md">}}\preformatted{---
options:
  run_r:
    enabled: true
---
}\if{html}{\out{</div>}}
}

\examples{
\dontrun{
# Simple calculation
btw_tool_run_r("2 + 2")

# Code with plot
btw_tool_run_r("hist(rnorm(100))")

# Code with warning
btw_tool_run_r("mean(c(1, 2, NA))")
}

}
\seealso{
\code{\link[=btw_tools]{btw_tools()}}
}
\concept{run tools}
