% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digital-ocean.R
\name{do_provision}
\alias{do_provision}
\title{Provision a DigitalOcean server for _server.yml applications}
\usage{
do_provision(droplet, ..., keyfile = do_keyfile())
}
\arguments{
\item{droplet}{The DigitalOcean droplet that you want to provision
(see \code{\link[analogsea:droplet]{analogsea::droplet()}}). If empty, a new DigitalOcean server will be created.}

\item{...}{Arguments passed into the \code{\link[analogsea:droplet_create]{analogsea::droplet_create()}} function.}

\item{keyfile}{Path to private key for authentication. By default, uses the
key for "digitalocean.com" from \code{\link[ssh:ssh_credentials]{ssh::ssh_key_info()}}.}
}
\value{
The DigitalOcean droplet
}
\description{
Create (if required), install the necessary prerequisites, and
deploy a _server.yml-based R server application on a DigitalOcean virtual machine.
You may sign up for a Digital Ocean account
\href{https://www.digitalocean.com?refcode=6119f0430dad&utm_campaign=Referral_Invite&utm_medium=Referral_Program&utm_source=CopyPaste}{here}.
You should configure an account ssh key with \code{\link[analogsea:key-crud]{analogsea::key_create()}} prior to using this method.
This command is idempotent, so feel free to run it on a single server multiple times.
}
\details{
Provisions a Ubuntu 24.04-x64 droplet with the following customizations:
\itemize{
\item A recent version of R installed
\item Common server dependencies installed
\item Directory structure at \verb{/var/server-apps} for deployed applications
\item The \code{nginx} web server installed to route web traffic from port 80 (HTTP)
\item \code{ufw} installed as a firewall to restrict access on the server. By default it only
allows incoming traffic on port 22 (SSH) and port 80 (HTTP).
\item A 4GB swap file is created to ensure that machines with little RAM (the default) are
able to get through the necessary R package compilations.
}
}
\note{
Please see \url{https://github.com/pachadotdev/analogsea/issues/205} in case
of an error by default \code{do_provision} and an error of
\code{"Error: Size is not available in this region."}.
}
\examples{
\dontrun{
  auth <- analogsea::do_oauth()

  analogsea::droplets()
  droplet <- do_provision(region = "sfo3")
  analogsea::droplets()

  # Deploy a _server.yml application
  do_deploy_server(
    droplet,
    "myapp",
    "local/path/to/app/",
    port=8000,
    forward=TRUE
  )
  if (interactive()) {
    utils::browseURL(do_ip(droplet, "/myapp"))
  }

  analogsea::droplet_delete(droplet)
}
}
