% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{dir_confusion_original}
\alias{dir_confusion_original}
\title{Compute confusion matrix for comparing two adjacency matrices}
\usage{
dir_confusion_original(est_amat, true_amat)
}
\arguments{
\item{est_amat}{The estimated adjacency matrix, or \code{tpdag}/\code{cpdag}
object as obtained from \link{tpc} or \link{pc}}

\item{true_amat}{The true adjacency matrix, or \code{tpdag}/\code{cpdag}
object as obtained from \link{tpc} or \link{pc}}
}
\value{
A list with entries \code{$tp} (number of true positives),  \code{$tn} (number of true negatives),
\code{$fp} (number of false positives), and  \code{$tp} (number of false negatives).
}
\description{
Two adjacency matrices are compared either in terms of adjacencies
(\code{type = "adj"}) or orientations (\code{type = "dir"}).
}
\details{
This is an old version of the function, included for possible
backwards compatibility. Edges are scored as follows: A correctly unoriented edge
counts as a true negative (TN). An undirected edge that should have been directed
counts as a false negative (FN). A directed edge that should have been
undirected counts as a false positive (FP). A directed edge oriented in the
correct direction counts as a true positive (TP). A directed edge
oriented in the incorrect direction counts as both a false positive (FP)
and a false negative (FN).
}
\examples{
#############################################################################
# Compare two adjacency matrices ############################################
#############################################################################
x1 <- matrix(c(0, 0, 0, 0,
               1, 0, 1, 0,
               1, 0, 0, 0, 
               0, 0, 1, 0), 4, 4, byrow = TRUE)
x2 <- matrix(c(0, 0, 1, 0,
               1, 0, 0, 0,
               0, 0, 0, 0, 
               1, 0, 1, 0), 4, 4, byrow = TRUE)

# confusion matrix for adjacencies
confusion(x2, x1)

# confusion matrix for conditional orientations
confusion(x2, x1, type = "dir")

#############################################################################
# Compare estimated cpdag with true adjacency matrix ########################
#############################################################################
# simulate DAG adjacency matrix and Gaussian data
set.seed(123)
x3 <- matrix(c(0, 0, 0, 0,
               1, 0, 1, 0,
               0, 0, 0, 0, 
               0, 0, 1, 0), 4, 4, byrow = TRUE)
ex_data <- simGausFromDAG(x3, n = 50)
pcres <- pc(ex_data, sparsity = 0.1, test = corTest)

# compare adjacencies with true amat (x1)
confusion(pcres, x3)

# compare conditional orientations with true amat
confusion(pcres, x1, type = "dir")


}
