% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tpag}
\alias{plot.tpag}
\title{Plot temporal partial ancestral graph (TPAG)}
\usage{
\method{plot}{tpag}(x, ...)
}
\arguments{
\item{x}{tpag object
to be plotted (as outputted from \code{\link{tfci}}).}

\item{...}{Currently not in use.}
}
\value{
No return value, the function is called for its side-effects (plotting).
}
\description{
Plot temporal partial ancestral graph (TPAG)
}
\examples{
# simulate linear Gaussian data w unobserved variable L1
n <- 100
L1 <- rnorm(n) 
X1 <- rnorm(n)
X2 <- L1 + X1 + rnorm(n)
X3 <- X1 + rnorm(n)
X4 <- X3 + L1 + rnorm(n)
d <- data.frame(p1_X1 = X1,
                p1_X2 = X2,
                p2_X3 = X3,
                p2_X4 = X4)

# use FCI algorithm to recover PAG                
res <- tfci(d, order = c("p1", "p2"), test = corTest)

# plot
plot(res)
}
\author{
This code is a modification of the fciAlgo plotting method implemented
in the pcalg package.
}
