% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{year_range}
\alias{year_range}
\title{Get Census Year Coverage for a Province}
\usage{
year_range(reg_code = NULL, harmonized = TRUE, before_expand = TRUE)
}
\arguments{
\item{reg_code}{Character or numeric. Province code. Required if
\code{harmonized = FALSE}.}

\item{harmonized}{Logical. If \code{TRUE} (default), returns harmonized
coverage (1971–2020). If \code{FALSE}, uses non-harmonized coverage.}

\item{before_expand}{Logical. Only relevant if \code{harmonized = FALSE}
and the province has expanded. If \code{TRUE} (default), returns coverage
before expansion; if \code{FALSE}, returns coverage after expansion.}
}
\value{
An integer vector of census years, with labels as names.
}
\description{
This function determines the range of census years available for a given
province. Coverage depends on whether harmonized or non-harmonized codes are
used, and in the case of non-harmonized data, whether the province has
experienced administrative expansion (pemekaran).
}
\details{
\itemize{
\item For harmonized data (\code{harmonized = TRUE}), the full coverage
of 1971–2020 is returned.
\item For non-harmonized data (\code{harmonized = FALSE}), coverage is
determined based on the internal dataset \code{prov_coverage}.
\item If the province has expanded, coverage depends on
\code{before_expand}.
\item Census year labels are retrieved from
\code{ref_label$census_label}.
}
}
\examples{
\dontrun{
# Harmonized coverage (1971–2020)
year_range(harmonized = TRUE)

# non-harmonized coverage for a province (before expansion)
get_code_label(5) #returns list of non-harmonized province code
year_range(reg_code = 1400, harmonized = FALSE, before_expand = TRUE)

# non-harmonized coverage for a province (after expansion)
year_range(reg_code = 1400, harmonized = FALSE, before_expand = FALSE)
}

}
\seealso{
\code{\link[=is_expanded]{is_expanded()}}, \code{\link[=get_code_label]{get_code_label()}}
}
