% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_formula.R
\name{choice_formula}
\alias{choice_formula}
\alias{print.choice_formula}
\title{Define choice model formula}
\usage{
choice_formula(formula, error_term = "probit", random_effects = character())

\method{print}{choice_formula}(x, ...)
}
\arguments{
\item{formula}{[\code{formula}]\cr
A symbolic description of the choice model, see details.}

\item{error_term}{[\code{character(1)}]\cr
Defines the model's error term. Current options are:
\itemize{
\item \code{"probit"} (default): errors are multivariate normally distributed
\item \code{"logit"}: errors follow a type-I extreme value distribution
}}

\item{random_effects}{[\code{character()}]\cr
Defines the random effects in the model. The expected format of elements in
\code{random_effects} is \code{"<covariate>" = "<distribution>"}, where
\code{"<covariate>"} is the name of a variable on the \code{formula} right-hand side.
Every random effect must reference an explicit covariate (or \code{"ASC"} for
alternative-specific constants) that appears in the supplied model formula.

Current options for \code{"<distribution>"} are:
\itemize{
\item \code{"cn"}: correlated (with other \code{"cn"} random effects) normal distribution
}

To have random effects for the ASCs, use \code{"ASC"} for \code{"<covariate>"}.}

\item{x}{[\code{choice_formula}]\cr
A \code{choice_formula} object.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{choice_formula}, which is a \code{list} of the elements:
\describe{
\item{\code{formula}}{The model formula.}
\item{\code{error_term}}{The name of the model's error term specification.}
\item{\code{choice}}{The name of the response variable.}
\item{\code{covariate_types}}{The (up to) three different types of covariates.}
\item{\code{ASC}}{Does the model have ASCs?}
\item{\code{random_effects}}{The names of covariates with random effects.}
}
}
\description{
The \code{choice_formula} object defines the choice model equation.
}
\section{Specifying the model formula}{

The structure of \code{formula} is \code{choice ~ A | B | C}, i.e., a standard
\code{\link[stats]{formula}} object but with three parts on the right-hand
side, separated by \code{|}, where
\itemize{
\item \code{choice} is the name of the discrete response variable,
\item \code{A} are names of \strong{alternative-specific covariates} with
\strong{a coefficient that is constant across alternatives},
\item \code{B} are names of \strong{covariates that are constant across
alternatives},
\item and \code{C} are names of \strong{alternative-specific covariates}
with \strong{alternative-specific coefficients}.
}

The following rules apply:
\enumerate{
\item By default, intercepts (referred to as alternative-specific
constants, ASCs) are added to the model. They can be removed by adding
\code{+ 0} in the second part, e.g., \code{choice ~ A | B + 0 | C}. To not include
any covariates of the second type but to estimate ASCs, add \code{1} in the
second part, e.g., \code{choice ~ A | 1 | C}. The expression
\code{choice ~ A | 0 | C} is interpreted as no covariates of the second type and
no ASCs.
\item To not include covariates of any type, add \code{0} in the respective
part, e.g., \code{choice ~ 0 | B | C}.
\item Some parts of the formula can be omitted when there is no ambiguity.
For example, \code{choice ~ A} is equivalent to \code{choice ~ A | 1 | 0}.
\item Multiple covariates in one part are separated by a \code{+} sign, e.g.,
\code{choice ~ A1 + A2}.
\item Arithmetic transformations of covariates in all three parts of the
right-hand side are possible via the function \code{I()}, e.g.,
\code{choice ~ I(A1^2 + A2 * 2)}. In this case, a random effect can be defined
for the transformed covariate, e.g.,
\code{random_effects = c("I(A1^2 + A2 * 2)" = "cn")}.
}
}

\examples{
choice_formula(
  formula = choice ~ I(A^2 + 1) | B | I(log(C)),
  error_term = "probit",
  random_effects = c("I(A^2+1)" = "cn", "B" = "cn")
)
}
\keyword{model}
