% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_responses.R
\name{choice_responses}
\alias{choice_responses}
\alias{generate_choice_responses}
\title{Define choice response}
\usage{
choice_responses(
  data_frame,
  column_choice = "choice",
  column_decider = "deciderID",
  column_occasion = NULL,
  cross_section = FALSE
)

generate_choice_responses(
  choice_effects,
  choice_covariates = generate_choice_covariates(choice_effects = choice_effects),
  choice_parameters = generate_choice_parameters(choice_effects = choice_effects),
  choice_identifiers = extract_choice_identifiers(choice_covariates),
  choice_preferences = generate_choice_preferences(choice_parameters = choice_parameters,
    choice_effects = choice_effects, choice_identifiers = choice_identifiers),
  column_choice = "choice",
  choice_type = c("auto", "discrete", "ordered", "ranked")
)
}
\arguments{
\item{data_frame}{[\code{data.frame}]\cr
Contains the choice responses.}

\item{column_choice}{[\code{character(1)}]\cr
The column name of \code{data_frame} with the choice responses.}

\item{column_decider}{[\code{character(1)}]\cr
The name of the identifier column for deciders.}

\item{column_occasion}{[\code{character(1)} | \code{NULL}]\cr
The name of the identifier column for choice occasions (panel data).
Can be \code{NULL} for the cross-sectional case.}

\item{cross_section}{[\code{logical(1)}]\cr
Treat choice data as cross-sectional?}

\item{choice_effects}{[\code{choice_effects}]\cr
A \code{\link{choice_effects}} object describing the model structure.}

\item{choice_covariates}{[\code{choice_covariates}]\cr
Covariates used to construct utilities.}

\item{choice_parameters}{[\code{choice_parameters}]\cr
Model parameters supplying the mean and covariance components.}

\item{choice_identifiers}{[\code{choice_identifiers}]\cr
Identifiers describing the panel or cross-sectional structure.}

\item{choice_preferences}{[\code{choice_preferences}]\cr
Preference draws to simulate the choices.}

\item{choice_type}{[\code{character(1)}]\cr
The response type to simulate. Use \code{"auto"} (default) to derive the type
from \code{choice_alternatives}, or explicitly request \code{"discrete"},
\code{"ordered"}, or \code{"ranked"} outcomes.}
}
\value{
A \code{data.frame}.
}
\description{
The \code{choice_responses} object defines the observed discrete responses.
Additional response columns (for example ranked choice indicators) are
preserved so they can be merged with covariates downstream.
\itemize{
\item \code{generate_choice_responses()} simulates choices
}
}
\examples{
choice_effects <- choice_effects(
  choice_formula = choice_formula(
    formula = choice ~ price | time,
    error_term = "probit"
  ),
  choice_alternatives = choice_alternatives(J = 5)
)
generate_choice_responses(choice_effects = choice_effects)
}
\keyword{data}
