\name{apfel_ponv}
\alias{apfel_ponv}
\title{
Apfel Score for Postoperative Nausea and Vomiting
}
\description{
Calculates the Apfel Score to estimate the risk of Postoperative Nausea and Vomiting (PONV) in adult patients undergoing inhalational anesthesia. The score ranges from 0 to 4, with each risk factor adding approximately 20\% to the baseline risk.
}
\usage{
apfel_ponv(female_sex, history_ponv_motion_sickness, non_smoker, postop_opioids)
}
\arguments{
  \item{female_sex}{
Numeric (0 or 1). Patient is female. (1 = Yes, +1 point).
}
  \item{history_ponv_motion_sickness}{
Numeric (0 or 1). History of PONV or motion sickness. (1 = Yes, +1 point).
}
  \item{non_smoker}{
Numeric (0 or 1). Patient is a non-smoker. (1 = Yes, +1 point).
}
  \item{postop_opioids}{
Numeric (0 or 1). Expected use of postoperative opioids. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{Apfel_Score}{The total number of risk factors present (Range 0-4).}
\item{Est_Risk_PONV}{The estimated probability of PONV (10\%, 21\%, 39\%, 61\%, or 79\%).}
}
\references{
Apfel CC, Laara E, Koivuranta M, Greim CA, Roewer N. A simplified risk score for predicting postoperative nausea and vomiting: conclusions from cross-validations between two centers. Anesthesiology. 1999;91(3):693-700. doi:10.1097/00000542-199909000-00022
}
\examples{

# Example 1: High Risk
# Female, History of Motion Sickness, Non-Smoker, Getting Opioids
# Score = 4 (79\% Risk)
apfel_ponv(1, 1, 1, 1)

# Example 2: Low Risk
# Male, Smoker, No Hx, No Opioids
# Score = 0 (10\% Risk)
apfel_ponv(0, 0, 0, 0)
}
