\name{bicarbonate_deficit}
\alias{bicarbonate_deficit}
\title{
Bicarbonate Deficit Calculator
}
\description{
Calculates the total body bicarbonate deficit in patients with metabolic acidosis. This estimate is used to guide replacement therapy with Sodium Bicarbonate. The formula relies on the apparent volume of distribution of bicarbonate (typically estimated as 40-50\% of body weight).
}
\usage{
bicarbonate_deficit(weight_kg, current_hco3, desired_hco3 = 24,
                    volume_distribution_fraction = 0.4)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient actual body weight in kilograms.
}
  \item{current_hco3}{
Numeric. Patient's current serum bicarbonate level (mEq/L).
}
  \item{desired_hco3}{
Numeric. The target serum bicarbonate level (mEq/L). Defaults to 24 mEq/L, though lower targets (e.g., 10-12 mEq/L) are often used in acute severe acidosis to avoid overcorrection.
}
  \item{volume_distribution_fraction}{
Numeric. The apparent volume of distribution for bicarbonate as a fraction of body weight. Defaults to 0.4 (40\%). In severe acidosis, this may be higher (0.5 to 0.8).
}
}
\value{
A list containing:
\item{Bicarbonate_Deficit_mEq}{The total calculated deficit in milliequivalents.}
\item{Recommended_Initial_Dose_mEq}{50\% of the total deficit, representing the standard safety recommendation for the first 24 hours or initial bolus.}
}
\references{
Adrogué HJ, Madias NE. Management of life-threatening acid-base disorders. N Engl J Med. 1998;338(1):26-34. doi:10.1056/NEJM199801013380106
}
\examples{

# Example 1: Severe Acidosis
# 70kg patient, current HCO3 8, target 15 (partial correction)
# Deficit = 0.4 * 70 * (15 - 8) = 196 mEq
bicarbonate_deficit(70, 8, 15)

# Example 2: Full Correction Calculation
# 80kg patient, current 12, target 24
# Deficit = 0.4 * 80 * (24 - 12) = 384 mEq
bicarbonate_deficit(80, 12, 24)
}
