\name{brief_addiction_monitor}
\alias{brief_addiction_monitor}
\title{
Brief Addiction Monitor (BAM)
}
\description{
Calculates domain scores for the Brief Addiction Monitor (BAM), a 17-item instrument used to monitor progress in recovery from substance use disorders. It evaluates three key domains over the past 30 days: Substance Use, Risk Factors, and Protective Factors.
}
\usage{
brief_addiction_monitor(alcohol_days, drug_days, marijuana_days,
                        risk_health, risk_sleep, risk_anxiety, risk_depression,
                        risk_cravings, risk_situations,
                        prot_confidence, prot_support, prot_spiritual,
                        prot_work, prot_income, prot_family,
                        prot_self_help_days, prot_commitment)
}
\arguments{
  \item{alcohol_days}{Numeric (0-30). Days of alcohol use in the past 30 days.}
  \item{drug_days}{Numeric (0-30). Days of illegal drug use in the past 30 days.}
  \item{marijuana_days}{Numeric (0-30). Days of marijuana use in the past 30 days.}
  \item{risk_health}{Numeric (0-4). Rating of poor physical health (0=Not at all, 4=Extremely).}
  \item{risk_sleep}{Numeric (0-4). Rating of sleep problems.}
  \item{risk_anxiety}{Numeric (0-4). Rating of anxiety/tension.}
  \item{risk_depression}{Numeric (0-4). Rating of depression/sadness.}
  \item{risk_cravings}{Numeric (0-4). Rating of cravings/urges to use.}
  \item{risk_situations}{Numeric (0-4). Rating of exposure to risky situations.}
  \item{prot_confidence}{Numeric (0-4). Rating of confidence in staying sober.}
  \item{prot_support}{Numeric (0-4). Rating of support for recovery.}
  \item{prot_spiritual}{Numeric (0-4). Rating of spiritual support.}
  \item{prot_work}{Numeric (0-4). Rating of satisfaction with work/school progress.}
  \item{prot_income}{Numeric (0-4). Rating of income sufficiency.}
  \item{prot_family}{Numeric (0-4). Rating of family/friend support.}
  \item{prot_self_help_days}{Numeric (0-30). Days of attendance at self-help groups (AA/NA/SMART) in the past 30 days.}
  \item{prot_commitment}{Numeric (0-4). Rating of commitment to sobriety.}
}
\value{
A list containing:
\item{Use_Total_Days}{Sum of days using Alcohol, Drugs, and Marijuana.}
\item{Risk_Score_Total}{Sum of the 6 risk items (Range 0-24).}
\item{Protective_Likert_Sum}{Sum of the 7 Likert-scale protective items (Range 0-28).}
\item{Self_Help_Days}{Raw count of self-help days (0-30).}
}
\references{
Cacciola JS, Alterman AI, Dephilippis D, et al. Development and initial evaluation of the Brief Addiction Monitor (BAM). J Subst Abuse Treat. 2013;44(3):256-263. doi:10.1016/j.jsat.2012.07.013
}
\examples{

# Example 1: High Risk Profile
# 15 days alcohol, High cravings (4), Low confidence (1)
brief_addiction_monitor(15, 0, 0, 2, 2, 3, 3, 4, 3, 1, 1, 0, 2, 1, 1, 0, 1)

# Example 2: Strong Recovery Profile
# 0 days use, Low risk factors, High protection, 12 days self-help
brief_addiction_monitor(0, 0, 0, 0, 0, 1, 0, 1, 0, 4, 4, 3, 4, 3, 4, 12, 4)
}
