\name{bun_creatinine_ratio}
\alias{bun_creatinine_ratio}
\title{
BUN/Creatinine Ratio
}
\description{
Calculates the Blood Urea Nitrogen (BUN) to Creatinine ratio. This ratio helps differentiate between prerenal, intrinsic renal, and postrenal causes of acute kidney injury (AKI). The calculation standardizes inputs to mg/dL before computing the ratio to ensure consistent application of the 10:1 and 20:1 clinical thresholds.
}
\usage{
bun_creatinine_ratio(bun, creatinine, bun_units = "mg/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{bun}{
Numeric. Blood Urea Nitrogen level.
}
  \item{creatinine}{
Numeric. Serum Creatinine level.
}
  \item{bun_units}{
String. Units for BUN input. Options: "mg/dL" (default) or "mmol/L" (Urea).
}
  \item{creatinine_units}{
String. Units for Creatinine input. Options: "mg/dL" (default), "umol/L", or "mmol/L".
}
}
\value{
A list containing:
\item{BUN_Creatinine_Ratio}{The calculated dimensionless ratio (based on mg/dL values).}
\item{Interpretation}{Clinical classification (Prerenal, Normal/Postrenal, Intrarenal).}
\item{Possible_Causes}{List of potential etiologies associated with the ratio range.}
}
\references{
Dossetor JB. Creatininemia versus uremia. The relative significance of blood urea nitrogen and serum creatinine concentrations in azotemia. Ann Intern Med. 1966;65(6):1287-1299. doi:10.7326/0003-4819-65-6-1287
}
\examples{

# Example 1: Prerenal Azotemia (Dehydration)
# BUN 40 mg/dL, Cr 1.0 mg/dL
# Ratio = 40 (>20)
bun_creatinine_ratio(40, 1.0)

# Example 2: Intrinsic Renal Disease (ATN)
# Urea 10 mmol/L, Cr 300 umol/L
# BUN = 10 * 2.8 = 28 mg/dL
# Cr = 300 / 88.4 = 3.39 mg/dL
# Ratio = 28 / 3.39 = 8.2 (<10)
bun_creatinine_ratio(10, 300, "mmol/L", "umol/L")
}
