\name{comm_opioid_misuse_measure}
\alias{comm_opioid_misuse_measure}
\title{
Current Opioid Misuse Measure (COMM)
}
\description{
Calculates the COMM score, a 17-item patient self-report questionnaire designed to identify current aberrant drug-related behavior in chronic pain patients prescribed opioids. Each item assesses the frequency of a specific behavior or symptom over the past 30 days.
}
\usage{
comm_opioid_misuse_measure(q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12,
                           q13, q14, q15, q16, q17)
}
\arguments{
  \item{q1}{Numeric (0-4). Trouble thinking clearly or had memory problems?}
  \item{q2}{Numeric (0-4). People complain that your speech is slurred or that you look sedated?}
  \item{q3}{Numeric (0-4). Felt that your pain medication is not working or complained about it?}
  \item{q4}{Numeric (0-4). Spent time thinking about your medication or when you will take the next dose?}
  \item{q5}{Numeric (0-4). Taken your medication more often than prescribed?}
  \item{q6}{Numeric (0-4). Needed to take pain medication at a higher dose than prescribed?}
  \item{q7}{Numeric (0-4). Borrowed pain medication from someone else?}
  \item{q8}{Numeric (0-4). Used pain medication for symptoms other than pain (e.g., sleep, mood)?}
  \item{q9}{Numeric (0-4). Medications interfered with ability to do your job or schoolwork?}
  \item{q10}{Numeric (0-4). Family/friends worried about your medication use?}
  \item{q11}{Numeric (0-4). Felt angry or irritable?}
  \item{q12}{Numeric (0-4). Had mood swings?}
  \item{q13}{Numeric (0-4). Doctor worried about your medication use or wanted to monitor you closely?}
  \item{q14}{Numeric (0-4). Seen other doctors to get more medication?}
  \item{q15}{Numeric (0-4). Lied or exaggerated pain to get a prescription?}
  \item{q16}{Numeric (0-4). Had medications lost or stolen?}
  \item{q17}{Numeric (0-4). Had trouble with the law or driving offenses?}
}
\details{
\strong{Scoring Key (Last 30 Days):}
0 = Never
1 = Seldom
2 = Sometimes
3 = Often
4 = Very Often
}
\value{
A list containing:
\item{COMM_Score}{The total calculated score (Range 0-68).}
\item{Result}{"Positive Screen" if Score >= 9, otherwise "Negative Screen".}
\item{Interpretation}{Clinical guidance regarding the likelihood of misuse.}
}
\references{
Butler SF, Budman SH, Fernandez KC, et al. Development and validation of the Current Opioid Misuse Measure. Pain. 2007;130(1-2):144-156. doi:10.1016/j.pain.2007.01.014
}
\examples{

# Example 1: Positive Screen
# Frequent anger (3), Mood swings (3), Thinking about meds (3)
# Score = 9
comm_opioid_misuse_measure(0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0)

# Example 2: Negative Screen
# All Never (0)
comm_opioid_misuse_measure(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
