\name{fick_cardiac_output}
\alias{fick_cardiac_output}
\title{
Cardiac Output (Fick's Formula)
}
\description{
Calculates Cardiac Output using the Fick principle, which states that the blood flow through an organ is equal to the uptake or release of a substance by that organ divided by the arteriovenous difference of that substance. In this context, oxygen is the substance used.
}
\usage{
fick_cardiac_output(hemoglobin_g_dl, sa_o2_percent, sv_o2_percent,
                    vo2_ml_min, pa_o2_mmhg = NULL, pv_o2_mmhg = NULL)
}
\arguments{
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin concentration in g/dL.
}
  \item{sa_o2_percent}{
Numeric. Arterial Oxygen Saturation percentage (e.g., 98).
}
  \item{sv_o2_percent}{
Numeric. Mixed Venous Oxygen Saturation percentage (e.g., 75).
}
  \item{vo2_ml_min}{
Numeric. Oxygen Consumption in mL/min. This can be a measured value or an estimated value (often 125 mL/min/m2 * BSA).
}
  \item{pa_o2_mmhg}{
Numeric (Optional). Arterial partial pressure of oxygen. Used to calculate dissolved oxygen content.
}
  \item{pv_o2_mmhg}{
Numeric (Optional). Venous partial pressure of oxygen. Used to calculate dissolved oxygen content.
}
}
\value{
A list containing:
\item{Cardiac_Output_L_min}{The calculated cardiac output in Liters per minute.}
\item{Arterial_O2_Content_mL_dL}{Calculated arterial oxygen content (CaO2).}
\item{Venous_O2_Content_mL_dL}{Calculated venous oxygen content (CvO2).}
\item{AV_O2_Difference_mL_dL}{The arteriovenous oxygen difference.}
}
\references{
Fick A. Uber die messung des blutquantums in den herzventrikeln. Sitzungsberichte der Physikalisch-Medizinischen Gesellschaft zu Wurzburg. 1870;2:16.
}
\examples{

# Example 1: Standard Values
# Hgb 13 g/dL, SaO2 98\%, SvO2 70\%, VO2 250 mL/min
fick_cardiac_output(13, 98, 70, 250)

# Example 2: Including Dissolved Oxygen
# Hgb 10 g/dL, SaO2 100\%, SvO2 60\%, VO2 200 mL/min, PaO2 100, PvO2 35
fick_cardiac_output(10, 100, 60, 200, 100, 35)
}
