\name{geneva_score_revised}
\alias{geneva_score_revised}
\title{
Geneva Score (Revised) for Pulmonary Embolism
}
\description{
Calculates the Revised Geneva Score to estimate the probability of pulmonary embolism (PE) in patients with suspected PE. This score stratifies patients into low, intermediate, or high clinical pretest probability categories based on clinical variables, aiding in the decision-making process for further diagnostic testing.
}
\usage{
geneva_score_revised(age_gt_65, previous_dvt_pe, surgery_or_fracture_1mo,
                     active_malignancy, unilateral_lower_limb_pain, hemoptysis,
                     heart_rate, lower_limb_deep_vein_palpation_edema)
}
\arguments{
  \item{age_gt_65}{
Numeric (0 or 1). Age > 65 years. (1 = Yes, +1 point).
}
  \item{previous_dvt_pe}{
Numeric (0 or 1). Previous Deep Vein Thrombosis (DVT) or Pulmonary Embolism (PE). (1 = Yes, +3 points).
}
  \item{surgery_or_fracture_1mo}{
Numeric (0 or 1). Surgery (under general anesthesia) or lower limb fracture within the past month. (1 = Yes, +2 points).
}
  \item{active_malignancy}{
Numeric (0 or 1). Active malignant condition (solid or hematologic malignancy, currently active or considered cured < 1 year). (1 = Yes, +2 points).
}
  \item{unilateral_lower_limb_pain}{
Numeric (0 or 1). Unilateral lower limb pain. (1 = Yes, +3 points).
}
  \item{hemoptysis}{
Numeric (0 or 1). Hemoptysis. (1 = Yes, +2 points).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (75-94 bpm: +3 points; >= 95 bpm: +5 points).
}
  \item{lower_limb_deep_vein_palpation_edema}{
Numeric (0 or 1). Pain on lower limb deep venous palpation and unilateral edema. (1 = Yes, +4 points).
}
}
\value{
A list containing:
\item{Geneva_Score}{The calculated risk score (Range 0-22).}
\item{Risk_Probability}{Classification (Low 0-3, Intermediate 4-10, High >=11).}
\item{PE_Probability}{Estimated probability of PE based on risk category.}
\item{Recommendation}{Suggested diagnostic strategy.}
}
\references{
Le Gal G, Righini M, Roy PM, et al. Prediction of pulmonary embolism in the emergency department: the revised Geneva score. Ann Intern Med. 2006;144(3):165-171. doi:10.7326/0003-4819-144-3-200602070-00004
}
\examples{

# Example 1: Low Probability
# 40yo, HR 70, No other risk factors
# Score = 0
geneva_score_revised(0, 0, 0, 0, 0, 0, 70, 0)

# Example 2: High Probability
# 70yo (+1), HR 100 (+5), Unilateral Pain (+3), Pain on Palpation (+4)
# Score = 13
geneva_score_revised(1, 0, 0, 0, 1, 0, 100, 1)
}
