\name{he_macs_score}
\alias{he_macs_score}
\title{
HE-MACS (History and ECG-only Manchester Acute Coronary Syndromes) Decision Aid
}
\description{
Collects inputs for the HE-MACS decision aid, which stratifies the risk of Acute Coronary Syndrome (ACS) in patients presenting with chest pain using only history and ECG findings (no troponin required). It identifies "Very Low Risk" patients who may be candidates for early discharge.
}
\usage{
he_macs_score(age, sex, smoker, systolic_bp_lt_100, ecg_ischemia,
              sweating_observed, vomiting, pain_radiation_right_arm)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{smoker}{
Numeric (0 or 1). Current tobacco smoker. (1 = Yes).
}
  \item{systolic_bp_lt_100}{
Numeric (0 or 1). Systolic Blood Pressure < 100 mmHg. (1 = Yes).
}
  \item{ecg_ischemia}{
Numeric (0 or 1). Acute ECG ischemia (e.g., ST depression, T-wave inversion). (1 = Yes).
}
  \item{sweating_observed}{
Numeric (0 or 1). Sweating observed by the clinician. (1 = Yes).
}
  \item{vomiting}{
Numeric (0 or 1). Vomiting associated with pain. (1 = Yes).
}
  \item{pain_radiation_right_arm}{
Numeric (0 or 1). Pain radiating to the right arm or shoulder. (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_Model}{Name of the model used.}
\item{Recommendation}{General clinical guidance based on the HE-MACS stratification.}
\item{Inputs}{List of patient parameters used for stratification.}
}
\references{
Oliver G, Alghamdi A, Cameron S, et al. Enhanced triage for patients with suspected cardiac chest pain: the History and Electrocardiogram-only Manchester Acute Coronary Syndromes decision aid. Eur J Emerg Med. 2019;26(4):264-269. doi:10.1097/MEJ.0000000000000569
}
\examples{

# Example 1: High Risk Factors
# 65yo Male, Smoker, Sweating, ECG Ischemia
he_macs_score(65, "male", 1, 0, 1, 1, 0, 0)

# Example 2: Low Risk Factors
# 40yo Female, No symptoms/signs other than chest pain
he_macs_score(40, "female", 0, 0, 0, 0, 0, 0)
}
