\name{ips_e_score}
\alias{ips_e_score}
\title{
International Prognostic Score for Asymptomatic Early-stage CLL (IPS-E)
}
\description{
Calculates the IPS-E score to predict the risk of needing treatment (time to first treatment) within 5 years for patients with asymptomatic early-stage Chronic Lymphocytic Leukemia (CLL) (Binet A or Rai 0). The score uses three independent prognostic factors: IGHV mutation status, absolute lymphocyte count, and palpable lymph nodes.
}
\usage{
ips_e_score(ighv_unmutated, lymphocyte_count, palpable_nodes)
}
\arguments{
  \item{ighv_unmutated}{
Numeric (0 or 1). IGHV mutational status. (1 = Unmutated, 0 = Mutated). Unmutated status adds 1 point.
}
  \item{lymphocyte_count}{
Numeric. Absolute Lymphocyte Count (ALC) in x 10^9/L. (> 15 x 10^9/L adds 1 point).
}
  \item{palpable_nodes}{
Numeric (0 or 1). Presence of palpable lymph nodes. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{IPS_E_Score}{The calculated total score (Range 0-3).}
\item{Risk_Group}{Classification (Low: 0, Intermediate: 1, High: 2-3).}
\item{Est_5_Year_Treatment_Risk}{Estimated probability of requiring treatment within 5 years.}
}
\references{
Condoluci A, et al. International prognostic score for asymptomatic early-stage chronic lymphocytic leukemia. Blood. 2020;135(21):1859-1869. doi:10.1182/blood.2019003453
}
\examples{

# Example 1: High Risk
# Unmutated IGHV (1), ALC 20 (1), No Nodes (0)
# Score = 2
ips_e_score(1, 20, 0)

# Example 2: Low Risk
# Mutated IGHV (0), ALC 10 (0), No Nodes (0)
# Score = 0
ips_e_score(0, 10, 0)
}
