\name{moca_cognitive_assessment}
\alias{moca_cognitive_assessment}
\title{
Montreal Cognitive Assessment (MoCA)
}
\description{
Calculates the MoCA score, a rapid screening instrument for mild cognitive dysfunction. It assesses different cognitive domains: attention and concentration, executive functions, memory, language, visuoconstructional skills, conceptual thinking, calculations, and orientation. A score of 26 or above is considered normal. One point is added for subjects with 12 or fewer years of formal education (if total score is < 30).
}
\usage{
moca_cognitive_assessment(visuospatial, naming, attention, language, abstraction,
                          delayed_recall, orientation, education_years)
}
\arguments{
  \item{visuospatial}{
Numeric (0-5). Score for Visuospatial/Executive tasks (e.g., Trail Making B, Cube Copy, Clock Drawing).
}
  \item{naming}{
Numeric (0-3). Score for Naming task (e.g., Lion, Rhino, Camel).
}
  \item{attention}{
Numeric (0-6). Score for Attention tasks (Digit span, Letter A tap, Serial 7s).
}
  \item{language}{
Numeric (0-3). Score for Language tasks (Sentence repetition, Verbal fluency).
}
  \item{abstraction}{
Numeric (0-2). Score for Abstraction task (Similarity pairs).
}
  \item{delayed_recall}{
Numeric (0-5). Score for Delayed Recall (5 words).
}
  \item{orientation}{
Numeric (0-6). Score for Orientation (Date, Month, Year, Day, Place, City).
}
  \item{education_years}{
Numeric. Total years of formal education. Used to calculate the education adjustment (+1 if <= 12 years).
}
}
\value{
A list containing:
\item{MoCA_Score}{The calculated total score (Max 30).}
\item{Interpretation}{Clinical interpretation of the score (Normal vs Impairment levels).}
\item{Education_Adjustment}{Indication if the education point was applied.}
}
\references{
Nasreddine ZS, Phillips NA, Bédirian V, et al. The Montreal Cognitive Assessment, MoCA: a brief screening tool for mild cognitive impairment. J Am Geriatr Soc. 2005;53(4):695-699. doi:10.1111/j.1532-5415.2005.53221.x
}
\examples{

# Example 1: Normal Cognition
# All sections perfect, >12 years education
moca_cognitive_assessment(5, 3, 6, 3, 2, 5, 6, 16)

# Example 2: Mild Impairment with Education Bonus
# Raw score 22, 10 years education (+1 point)
# Result: 23
moca_cognitive_assessment(3, 3, 5, 2, 1, 3, 5, 10)
}
