\name{modified_gps_score}
\alias{modified_gps_score}
\title{
Modified Glasgow Prognostic Score (mGPS)
}
\description{
Calculates the Modified Glasgow Prognostic Score (mGPS) to predict survival outcomes in patients with operable and inoperable cancer. Unlike the original GPS, the mGPS assigns a score of 0 to patients with hypoalbuminemia if their CRP is normal, as isolated hypoalbuminemia is less strongly associated with cancer cachexia-related mortality.
}
\usage{
modified_gps_score(crp_mg_l, albumin_g_l)
}
\arguments{
  \item{crp_mg_l}{
Numeric. Serum C-Reactive Protein level in mg/L.
}
  \item{albumin_g_l}{
Numeric. Serum Albumin level in g/L.
}
}
\details{
\strong{Scoring Criteria:}
\itemize{
  \item \strong{Score 0}: CRP <= 10 mg/L (regardless of Albumin level).
  \item \strong{Score 1}: CRP > 10 mg/L AND Albumin >= 35 g/L.
  \item \strong{Score 2}: CRP > 10 mg/L AND Albumin < 35 g/L.
}
}
\value{
A list containing:
\item{mGPS_Score}{The calculated score (0, 1, or 2).}
\item{Prognosis}{Risk classification (Good, Intermediate, Poor).}
}
\references{
McMillan DC. The systemic inflammation-based Glasgow Prognostic Score: a decade of experience in patients with cancer. Cancer Treat Rev. 2013;39(5):534-540. doi:10.1016/j.ctrv.2012.08.003
}
\examples{

# Example 1: Low Risk (Normal CRP)
# CRP 8, Albumin 30 (Hypoalbuminemia ignored in mGPS)
# Score = 0
modified_gps_score(8, 30)

# Example 2: High Risk
# CRP 25, Albumin 28
# Score = 2
modified_gps_score(25, 28)
}
