\name{modified_nih_stroke_scale}
\alias{modified_nih_stroke_scale}
\title{
Modified NIH Stroke Scale (mNIHSS)
}
\description{
Calculates the Modified NIH Stroke Scale (mNIHSS) score. This version of the NIHSS improves interrater reliability by removing items that are often difficult to score consistently, specifically Level of Consciousness (1A), Facial Palsy, Ataxia, and Dysarthria. It is validated for use in telemedicine and retrospective chart reviews.
}
\usage{
modified_nih_stroke_scale(loc_questions, loc_commands, gaze, visual_fields,
                          motor_arm_left, motor_arm_right, motor_leg_left,
                          motor_leg_right, sensory, best_language,
                          extinction_inattention)
}
\arguments{
  \item{loc_questions}{
Numeric (0-2). LOC Questions (Month and Age).
0: Answers both correctly.
1: Answers one correctly.
2: Answers neither correctly.
}
  \item{loc_commands}{
Numeric (0-2). LOC Commands (Open/close eyes, grip/release hand).
0: Performs both tasks correctly.
1: Performs one task correctly.
2: Performs neither task correctly.
}
  \item{gaze}{
Numeric (0-2). Best Gaze.
0: Normal.
1: Partial gaze palsy.
2: Forced deviation.
}
  \item{visual_fields}{
Numeric (0-3). Visual Fields.
0: No visual loss.
1: Partial hemianopia.
2: Complete hemianopia.
3: Bilateral hemianopia.
}
  \item{motor_arm_left}{
Numeric (0-4). Motor Arm (Left).
0: No drift.
1: Drift.
2: Some effort against gravity.
3: No effort against gravity.
4: No movement.
}
  \item{motor_arm_right}{
Numeric (0-4). Motor Arm (Right).
}
  \item{motor_leg_left}{
Numeric (0-4). Motor Leg (Left).
}
  \item{motor_leg_right}{
Numeric (0-4). Motor Leg (Right).
}
  \item{sensory}{
Numeric (0-2). Sensory.
0: Normal.
1: Mild-to-moderate sensory loss.
2: Severe to total sensory loss.
}
  \item{best_language}{
Numeric (0-3). Best Language.
0: No aphasia.
1: Mild-to-moderate aphasia.
2: Severe aphasia.
3: Mute, global aphasia.
}
  \item{extinction_inattention}{
Numeric (0-2). Extinction and Inattention (formerly Neglect).
0: No abnormality.
1: Visual, tactile, auditory, spatial, or personal inattention.
2: Profound hemi-inattention or extinction to more than one modality.
}
}
\value{
A list containing:
\item{mNIHSS_Score}{The calculated total score (Range 0-31).}
\item{Severity}{Interpretation of stroke severity (Minor, Moderate, Severe).}
}
\references{
Meyer BC, Hemmen TM, Jackson CM, Lyden PD. Modified National Institutes of Health Stroke Scale for use in stroke clinical trials: reproducibility and validity. Stroke. 2002;33(5):1261-1266. doi:10.1161/01.str.0000015052.83017.8a
}
\examples{

# Example 1: Moderate Stroke
# Incorrect age (1), Partial gaze (1), L-Arm drift (1), L-Leg drift (1), Mild aphasia (1)
modified_nih_stroke_scale(1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0)

# Example 2: Severe Stroke
# No commands (2), Forced gaze (2), Complete hemianopia (2),
# R-Arm/Leg paralysis (4, 4), Global aphasia (3), Neglect (2)
modified_nih_stroke_scale(0, 2, 2, 2, 0, 4, 0, 4, 0, 3, 2)
}
