\name{pmp_mortality_score}
\alias{pmp_mortality_score}
\title{
Preoperative Mortality Predictor (PMP) Score
}
\description{
Calculates the Preoperative Mortality Predictor (PMP) Score, a risk stratification tool developed from the ACS-NSQIP database to predict 30-day mortality in general surgery patients. The score sums points assigned to 14 preoperative variables, including age, comorbidities, and functional status.
}
\usage{
pmp_mortality_score(age, inpatient_status, sepsis, poor_functional_status,
                    disseminated_cancer, cardiac_comorbidity, pulmonary_comorbidity,
                    renal_comorbidity, liver_comorbidity, steroid_use, weight_loss,
                    bleeding_disorder, dnr_status, obesity)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (<65: 0, 65-69: 0.5, 70-79: 1, >=80: 2).
}
  \item{inpatient_status}{
Numeric (0 or 1). Is the patient an inpatient? (1 = Yes, +6 pts).
}
  \item{sepsis}{
Numeric (0 or 1). Presence of sepsis, severe sepsis, or septic shock within 48 hours prior to surgery. (1 = Yes, +4 pts).
}
  \item{poor_functional_status}{
Numeric (0 or 1). Totally dependent functional status (requires total assistance for all daily activities). (1 = Yes, +3 pts).
}
  \item{disseminated_cancer}{
Numeric (0 or 1). Disseminated cancer. (1 = Yes, +1 pt).
}
  \item{cardiac_comorbidity}{
Numeric (0 or 1). Presence of cardiac comorbidities (History of CHF, MI, Angina, Peripheral Artery Disease, or Hypertension requiring medication). (1 = Yes, +5 pts).
}
  \item{pulmonary_comorbidity}{
Numeric (0 or 1). Presence of pulmonary comorbidities (Ventilator dependence, COPD, or current Pneumonia). (1 = Yes, +3 pts).
}
  \item{renal_comorbidity}{
Numeric (0 or 1). Presence of renal comorbidities (Dialysis or Acute Renal Failure). (1 = Yes, +1 pt).
}
  \item{liver_comorbidity}{
Numeric (0 or 1). Presence of liver comorbidities (Ascites or Esophageal Varices). (1 = Yes, +1 pt).
}
  \item{steroid_use}{
Numeric (0 or 1). Chronic steroid use for a chronic condition. (1 = Yes, +1 pt).
}
  \item{weight_loss}{
Numeric (0 or 1). >10\% loss of body weight in the last 6 months. (1 = Yes, +1 pt).
}
  \item{bleeding_disorder}{
Numeric (0 or 1). Presence of a bleeding disorder. (1 = Yes, +1 pt).
}
  \item{dnr_status}{
Numeric (0 or 1). Do Not Resuscitate (DNR) status. (1 = Yes, +1 pt).
}
  \item{obesity}{
Numeric (0 or 1). Obesity (BMI >= 30 kg/m^2). (1 = Yes, -1 pt).
}
}
\value{
A list containing:
\item{PMP_Score}{The calculated total risk score.}
\item{Interpretation}{General interpretation of the score (Higher score indicates higher mortality risk).}
}
\references{
Ghanem OM, et al. Predicting risk of death in general surgery patients on the basis of preoperative variables using American College of Surgeons National Surgical Quality Improvement Program data. Perm J. 2012;16(4):9-15. doi:10.7812/TPP/12-019
}
\examples{

# Example 1: High Risk
# 80yo (+2), Inpatient (+6), Cardiac (+5), Sepsis (+4)
# Score = 17
pmp_mortality_score(80, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Low Risk
# 45yo (0), Obesity (-1), No other factors
# Score = -1
pmp_mortality_score(45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1)
}
