\name{rse_asthma_score}
\alias{rse_asthma_score}
\title{
Risk Score for Asthma Exacerbation (RSE)
}
\description{
Calculates the Risk Score for Asthma Exacerbation (RSE) to predict the likelihood of an asthma exacerbation within the next 6 months. The score is derived from 5 clinical variables: BMI, ACQ-5 score, Post-bronchodilator FEV1, Rescue inhaler use, and GINA treatment step.
}
\usage{
rse_asthma_score(bmi_ge_30, acq5_score, fev1_percent_predicted,
                 rescue_inhaler_uses_per_day, gina_step_4_or_higher)
}
\arguments{
  \item{bmi_ge_30}{
Numeric (0 or 1). Is BMI >= 30 kg/m^2? (1 = Yes, +14 points).
}
  \item{acq5_score}{
Numeric. Asthma Control Questionnaire-5 (ACQ-5) Score. (<1.5: 0 pts, 1.5-2.49: +7 pts, >=2.5: +13 pts).
}
  \item{fev1_percent_predicted}{
Numeric. Post-bronchodilator FEV1 (% predicted). (>=90%: 0 pts, 80-89%: +13 pts, <80%: +20 pts).
}
  \item{rescue_inhaler_uses_per_day}{
Numeric. Average rescue inhaler usage per day. (<2: 0 pts, 2-3.9: +11 pts, >=4: +26 pts).
}
  \item{gina_step_4_or_higher}{
Numeric (0 or 1). Is the patient on GINA treatment step 4 or higher (e.g., medium/high dose ICS/LABA)? (1 = Yes, +27 points).
}
}
\value{
A list containing:
\item{RSE_Score}{The calculated total score (Range 0-100).}
\item{Risk_Category}{Estimated risk level for exacerbation within 6 months.}
}
\references{
Bateman ED, et al. Development and validation of a novel risk score for asthma exacerbations: The risk score for exacerbation. J Allergy Clin Immunol. 2015;135(6):1457-1464.e4. doi:10.1016/j.jaci.2014.12.1915
}
\examples{

# Example 1: High Risk
# BMI 32 (+14), ACQ 3.0 (+13), FEV1 70% (+20), Rescue 5/day (+26), GINA 4 (+27)
# Score = 100
rse_asthma_score(1, 3.0, 70, 5, 1)

# Example 2: Low Risk
# BMI 25 (0), ACQ 0.5 (0), FEV1 95% (0), Rescue 0 (0), GINA 2 (0)
# Score = 0
rse_asthma_score(0, 0.5, 95, 0, 0)
}
