% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_response_type.R
\name{identify_response_type}
\alias{identify_response_type}
\title{Detect response variable type for model selection}
\usage{
identify_response_type(df = NULL, response = NULL, quiet = FALSE, ...)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{response}{(optional, character string) Name of a response variable in \code{df}. Default: NULL.}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
character string: response type
}
\description{
Used by \code{\link[=f_auto]{f_auto()}} to identify the type of a response variable and select a proper modelling method to compute preference order.
Supported types are:
\itemize{
\item "continuous-binary": decimal numbers and two unique values; results in a warning, as this type is difficult to model.
\item "continuous-low": decimal numbers and 3 to 5 unique values; results in a message, as this type is difficult to model.
\item "continuous-high": decimal numbers and more than 5 unique values.
\item "integer-binomial": integer with 0s and 1s, suitable for binomial models.
\item "integer-binary": integer with 2 unique values other than 0 and 1; returns a warning, as this type is difficult to model.
\item "integer-low": integer with 3 to 5 unique values or meets specified thresholds.
\item "integer-high": integer with more than 5 unique values suitable for count modelling.
\item "categorical": character or factor with 2 or more levels.
\item "unknown": when the response type cannot be determined.
}
}
\examples{
data(vi_smol)

identify_response_type(
  df = vi_smol,
  response = "vi_numeric"
)

identify_response_type(
  df = vi_smol,
  response = "vi_counts"
)

identify_response_type(
  df = vi_smol,
  response = "vi_binomial"
)

identify_response_type(
  df = vi_smol,
  response = "vi_categorical"
)

identify_response_type(
  df = vi_smol,
  response = "vi_factor"
)

}
\seealso{
Other data_types: 
\code{\link{identify_categorical_variables}()},
\code{\link{identify_logical_variables}()},
\code{\link{identify_numeric_variables}()},
\code{\link{identify_valid_variables}()},
\code{\link{identify_zero_variance_variables}()}
}
\concept{data_types}
