% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_functions.R
\name{file.find}
\alias{file.find}
\title{Search for files}
\usage{
file.find(path = ".", pattern = NULL, up = 3, down = 1)
}
\arguments{
\item{path}{The directory to start searching from.  Default is the current
working directory.}

\item{pattern}{A full or partial name of the file to find.  If partial,
use the question mark (?) or asterisk (*) characters to indicate
the missing piece. Default is NULL, which will return all files.}

\item{up}{The number of levels above the base path to search. A value of
zero (0) means that you do not want to search up.  A value of -1 means
you do not want to include the base directory in the search results.
Default is 3 levels up.}

\item{down}{The number of levels below the base path to search. A value of
zero (0) means that you do not want to search down.  A value of -1 means you
do not want to include the base directory in the search results.
Default is 1 level down.}
}
\value{
A vector of one or more full file paths that met the search criteria.
The paths in the vector are returned
in the order of matches, according to the search algorithm.  That means
the first file found will be in position one, and the last file found
will be at the end of the vector. A NULL is returned if no
files met the search criteria.
}
\description{
A function to find files on the file system. The function
starts from the directory specified in the \code{path} parameter,
and searches outward in a radiating pattern
for the file name in the \code{pattern} parameter.
Results are returned as a vector of full paths in the order encountered.
The \code{up} and \code{down} parameters define the scope of the search.
This function has an advantage over \code{list.files} in that it can
search both up and down the file system, and limit the scope of the search.
}
\details{
The \code{file.find} function attempts to find a file based on
a full or partial file name.  The file name is passed
on the \code{pattern} parameter.
The \code{pattern} accepts both the single character question mark
wild card (?), and the asterisk multi-character wild card (*).
Searches are case-insensitive.

Starting from the base path specified in the \code{path} parameter,
the function searches
both above and below the base path in an alternating
pattern.  The function will first search the base path, then up one level,
then down one level, and so on.  The boundaries of
the search can be controlled by the \code{up} and \code{down} parameters.

You can control whether or not you want files from the base directory
included in the results.  To include these files, ensure both \code{up}
and \code{down} parameters are zero or greater.  If either of these
parameters is set to -1, the base path will be excluded.  For example,
\code{up = 3, down = 1} will search up three levels, and down one level.
\code{up = 3, down = 0} will search up three levels and not search down,
but will include the base directory.  \code{up = 3, down = -1} will search
up three levels, not search down, and not include the base directory in
the results.
}
\examples{
# Search for a file named "globals.R"
file.find(getwd(), "globals.R")

# Search for Rdata files
file.find(getwd(), "*.Rdata")

# Search for Rdata files up only
file.find(getwd(), "*.Rdata", up = 3, down = 0)

# Search for Rdata files up only, skipping the current working directory
file.find(getwd(), "*.Rdata", up = 3, down = -1)

}
\seealso{
Other fileops: 
\code{\link{Sys.path}()},
\code{\link{dir.find}()},
\code{\link{source.all}()}
}
\concept{fileops}
