% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMatrix.R
\name{CMIBiCondimat2mat}
\alias{CMIBiCondimat2mat}
\title{Normalized Conditional Mutual Information Between Two Matrices Given Two Conditions}
\usage{
CMIBiCondimat2mat(mat1, mat2, condi1, condi2, bin = 6, sp_order = 2)
}
\arguments{
\item{mat1}{A numeric matrix. For example, each row represents a gene and each column represents a sample.}

\item{mat2}{Another numeric matrix to compare against. Must have the same dimensions as `mat1`.}

\item{condi1}{A numeric condition vector, matching the number of columns in `mat1`.}

\item{condi2}{Another numeric condition vector, matching the number of columns in `mat1`.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}
}
\value{
A numeric vector representing the normalized conditional mutual information (CMI) between pairs of rows
from `mat1` and `mat2`, conditioned on `condi1` and `condi2`.
}
\description{
Computes the normalized conditional mutual information (CMI) between corresponding rows of two matrices,
given two condition variables, normalized by their individual information content. CMI is calculated using the specified number of bins and spline order.
}
\examples{
mat1 <- matrix(rnorm(10000), nrow = 100, ncol = 100)
mat2 <- matrix(rnorm(10000), nrow = 100, ncol = 100)
condi1 <- rnorm(100)
condi2 <- rnorm(100)
CMIBiCondimat2mat(mat1, mat2, condi1, condi2)

}
