% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getparlist}
\alias{getparlist}
\title{Get Parameter List}
\usage{
getparlist(
  looks = seq(500, 1000, 100),
  nmax = NULL,
  perpetual = FALSE,
  alloc.ratio = c(1, 1),
  num.per.block = c(1, 1),
  final.visit = 0,
  as.type = "asOF",
  alpha = 0.05,
  multiarm.mode = "CONFIDENCE-BASED",
  lmb.threshold = 0.1,
  lmb.conf.thresh = 0.9,
  outcome.type = "BINARY",
  estimator.type = "odds ratio",
  resprate = c(0.3, 0.5),
  ppm = rep(15, 300),
  special = NULL
)
}
\arguments{
\item{looks}{Vector of analysis times expressed by either number of patients accrued at each point or by rate of information accumulated.
If the former, last item should be the maximum sample size.
If the latter, last item is 1.
Expects a vector with length equal to the total number of total looks.}

\item{nmax}{Maximum sample size, specified if information rates are used for 'looks'.}

\item{perpetual}{Whether to run the trial perpetually (TRUE) or not (FALSE).
If TRUE, new treatment arms will be added when treatment arms are dropped, until there are no more arms left.
All treatments are included via the 'resprate' parameter. Default is FALSE.}

\item{alloc.ratio}{Allocation ratios for study arms relative to each other.
Expects vector with length equal to number of arms including control.
First number corresponds to control ratio.}

\item{num.per.block}{Number from each arm per block, for blocked randomization to balance co-variates.
Block size is 'sum(num.per.block)'. If a single number is provided, it will be assume to apply to each arm.}

\item{final.visit}{The number of days after intervention when the response information becomes available.
Default assumes immediate follow-up (0).}

\item{as.type}{The type of alpha spending function to use in group sequential design.
Default is 'asOF', O'Brien-Fleming-type.}

\item{alpha}{The alpha threshold to apply to each pairwise comparison to control in the final analysis.
Used together with the 'MONITOR FUTILITY', when an alpha spending function is not needed.
Default is 0.05, assuming a two-sided test.}

\item{multiarm.mode}{For multiple treatment arms, describes how arms are evaluated at each stage:
\itemize{
\item{"CONFIDENCE-BASED"(default): Evaluate arms against confidence-based rules}
\item{"DROP WORST": Drop the worst performing arm, and carry the remaining promising arms}
\item{"SELECT BEST": Select the best performing arm to carry forward, drop the rest}
\item{"ALL PROMISING": Carry forward all promising arms}
\item{"MONITOR FUTILITY": Only monitor for futility}
}}

\item{lmb.threshold}{Defined threshold for meaningful benefit. The direction of benefit/lacks benefit
depends on the data and outcome, and whether lower or higher is better. For ordinal data, lower is better and anything
greater than lmb.threshold lacks meaningful benefit. In that case we use a \code{genodds} estimator and \code{lmb.threshold} should be
below 1. For binary and continous data, higher is better and \code{lmb.threshold} should reflect that.
If the treatment effect is a ratio, it will be later converted to the logarithmic scale for confidence analysis.}

\item{lmb.conf.thresh}{Confidence threshold for futility. If confidence in lack of meaningful benefit (LMB)
is greater than this for a given treatment arm, the arm may be dropped. Default is 0.9.}

\item{outcome.type}{Type of primary outcome: "CONTINUOUS", "ORDINAL", or "BINARY".}

\item{estimator.type}{Type of estimator for binary data: "odds ratio", "risk diff", "risk ratio". Default is odds ratio.
For ordinal data, a generalised odds ratio 'genodds' is used. For continuous data, a difference of means is used.}

\item{resprate}{The response rates for control and treatment. For binary and continuous data, expects a vector which one number for each arm.
For ordinal data, expects a list of lists with the with list corresponding to control. If running perpetually,
include all treatments here, including those that will not initially be in the trial.}

\item{ppm}{Patients per month.While the maximum sample size for a non-perpetual trial is derived from 'looks',
in a perpetually setting the trial will continue to go so long as there are new treatments to add, and patients are
still accruing according to the length of ppm.}

\item{special}{Any information wishing to pass to the tag that will be added to the results dataframe under the 'misc' column.}
}
\value{
A parameter list used to generate a trial.
}
\description{
Generate a parameter list to generate a frequentist confidence trial
}
\examples{
# two-arm six-stage trial (PRESTO-REACH) with binary outcome measure

parlist <- getparlist(
looks=seq(500,1000,100),
perpetual=FALSE,
alloc.ratio=c(1,1),
num.per.block=c(1,1),
final.visit=0,
as.type="asOF",
multiarm.mode="CONFIDENCE-BASED",
lmb.threshold=0.95,
lmb.conf.thresh=0.9,
outcome.type='BINARY',
estimator.type='odds ratio',
resprate=c(0.3,0.5),
ppm=rep(15, 300))

# two-arm three-stage trial with 16-point ordinal outcome

resprate <- list(
ctrl = rep(1/16, 16),
trmt=c(
0.08119658, 0.07802130, 0.07502870,0.07220504, 0.06953783,0.06701574,
0.06462841, 0.06236641, 0.06022113,0.05818467, 0.05624978, 0.05440984,
0.05265872, 0.05099079,0.04940088, 0.04788419)
)

# create a list of input parameters

inputs <- list(
 lmb.threshold = 1.10,
 as.type = 'asOF',
 outcome.type = "ORDINAL",
 multiarm.mode='CONFIDENCE-BASED',
 num.per.block = c(1,1),
 final.visit = 180,
 ppm = rep(20, 300),
 perpetual=FALSE,
 resprate=resprate,
 looks=c(500,1000,1500)
 )
 # pass parameters in through "inputs"
 parlist <- do.call("getparlist", inputs)
}
