% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fisher_midP_test_2x2.R
\name{Fisher_midP_test_2x2}
\alias{Fisher_midP_test_2x2}
\title{The Fisher mid-P test for association in 2x2 tables}
\usage{
Fisher_midP_test_2x2(n, statistic = "hypergeometric")
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{statistic}{'hypergeometric' (i.e. Fisher-Irwin default), 'Pearson', or 'LR' (likelihood ratio)}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Fisher mid-P test for association in 2x2 tables

Described in Chapter 4 "The 2x2 Table"
}
\section{Table orientation}{
 In most study designs, rows designate a grouping of the data, for
instance, into treatment or exposure groups, while the columns indicate a
dichotomous outcome, usually with the first column representing the outcome
of interest. This designation of rows and columns may not be relevant in all
study designs, please see the introduction to chapter 4 for details.
}

\examples{
Fisher_midP_test_2x2(tea)
Fisher_midP_test_2x2(perondi_2004)
Fisher_midP_test_2x2(lampasona_2013)
Fisher_midP_test_2x2(ritland_2007)
}
