% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{forest_corr}
\alias{forest_corr}
\title{Forest Plot for Correlation Coefficients}
\usage{
forest_corr(
  dat,
  r_col = "r",
  n_col = "n",
  study_col = "Study",
  xlab = "Correlation (r)",
  title = "Correlation Forest Plot",
  xlim = c(-2.5, 1.5),
  diamond.col = "red",
  study.col = "blue",
  CI.col = "blue",
  square.size = 6,
  text_size = 3.5,
  xpos_study = -1.3,
  xpos_n = -1.1,
  xpos_ci = 1.2,
  xpos_weight = 1.45,
  xpos_pooled_label = NULL,
  xpos_pooled_value = NULL,
  contour_breaks = c(-1, -0.5, -0.3, -0.1, 0, 0.1, 0.3, 0.5, 1),
  contour_colors = c("gray70", "gray50", "gray30", "gray10", "gray70", "gray50",
    "gray30", "gray10")
)
}
\arguments{
\item{dat}{Data frame containing study-level correlation data.}

\item{r_col}{Character. Name of the column containing correlation coefficients. Default is \code{"r"}.}

\item{n_col}{Character. Name of the column containing sample sizes. Default is \code{"n"}.}

\item{study_col}{Character. Name of the column containing study labels. Default is \code{"Study"}.}

\item{xlab}{Character. Label for the x-axis. Default is \code{"Correlation (r)"}.}

\item{title}{Character. Plot title. Default is \code{"Correlation Forest Plot"}.}

\item{xlim}{Numeric vector of length 2. Limits for the x-axis. Default is \code{c(-2.5,1.5)}.}

\item{diamond.col}{Color for the pooled effect diamond. Default is \code{"red"}.}

\item{study.col}{Color for the study points. Default is \code{"blue"}.}

\item{CI.col}{Color for the horizontal confidence intervals. Default is \code{"blue"}.}

\item{square.size}{Numeric. Size of the squares representing study effect sizes. Default is \code{6}.}

\item{text_size}{Numeric. Size of text annotations. Default is \code{3.5}.}

\item{xpos_study}{Numeric. X-position for study labels. Default is \code{-1.3}.}

\item{xpos_n}{Numeric. X-position for sample size labels. Default is \code{-1.1}.}

\item{xpos_ci}{Numeric. X-position for correlation (95\% CI) labels. Default is \code{1.2}.}

\item{xpos_weight}{Numeric. X-position for study weight labels. Default is \code{1.45}.}

\item{xpos_pooled_label}{Numeric. X-position for the pooled effect label. Default is calculated automatically.}

\item{xpos_pooled_value}{Numeric. X-position for the pooled effect value. Default is calculated automatically.}

\item{contour_breaks}{Numeric vector. Breakpoints for contour shading along the x-axis. Default is \code{c(-1, -0.5, -0.3,-0.1, 0, 0.1,  0.3, 0.5, 1)}.}

\item{contour_colors}{Character vector. Colors corresponding to contour breaks. Default is \code{c("gray70","gray50","gray30", "gray10", "gray70", "gray50","gray30","gray10")}.}
}
\value{
A \code{ggplot} object representing the correlation forest plot.
}
\description{
Creates a contour-enhanced forest plot for correlation coefficients from multiple studies.
Applies Fisher's Z transformation for meta-analysis and displays study-level correlations
with 95\% confidence intervals, pooled correlation, weights, and heterogeneity statistics.
}
\examples{
\dontrun{
dat <- data.frame(
  Study = c("Smith 2010","Jones 2012","Lee 2015","Kim 2018"),
  r = c(0.2, 0.35, -0.1, 0.5),
  n = c(50, 120, 80, 60)
)
forest_corr(dat)
}
}
