% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{forest_prev}
\alias{forest_prev}
\title{Prevalence Forest Plot}
\usage{
forest_prev(
  dat,
  events_col = "events",
  n_col = "n",
  study_col = "Study",
  xlab = "Prevalence (\%)",
  title = "Prevalence Forest Plot",
  xlim = c(-25, 140),
  diamond.col = "red",
  study.col = "blue",
  CI.col = "blue",
  square.size = 7,
  text_size = 3.5,
  xpos_study = -12,
  xpos_events = -5,
  xpos_prev = 50,
  xpos_weight = 55,
  xpos_pooled_label = NULL,
  xpos_pooled_value = NULL,
  contour_breaks = c(0, 5, 10, 25, 50),
  contour_colors = c("gray90", "gray70", "gray50", "gray30"),
  legend_title = "Prevalence"
)
}
\arguments{
\item{dat}{A data frame containing study-level prevalence data.}

\item{events_col}{Name of the column containing the number of events.}

\item{n_col}{Name of the column containing the total sample size.}

\item{study_col}{Name of the column with study labels.}

\item{xlab}{Label for the x-axis. Default is \code{"Prevalence (\%)"}.}

\item{title}{Plot title.}

\item{xlim}{Numeric vector of length 2 specifying x-axis limits.}

\item{diamond.col}{Color of the pooled prevalence diamond.}

\item{study.col}{Color of the study points.}

\item{CI.col}{Color of the confidence intervals.}

\item{square.size}{Size of the study-level squares.}

\item{text_size}{Base text size for labels and annotations.}

\item{xpos_study}{X-axis position for study labels.}

\item{xpos_events}{X-axis position for event counts.}

\item{xpos_prev}{X-axis position for prevalence values.}

\item{xpos_weight}{X-axis position for study weights.}

\item{xpos_pooled_label}{X-axis position for pooled label (optional; defaults relative to pooled prevalence).}

\item{xpos_pooled_value}{X-axis position for pooled value (optional; defaults relative to pooled prevalence).}

\item{contour_breaks}{Numeric vector defining contour thresholds.}

\item{contour_colors}{Colors for contour shading.}

\item{legend_title}{Title for the contour legend.}
}
\value{
A ggplot object representing the prevalence forest plot.
}
\description{
Generates a forest plot for prevalence data with study-level estimates, confidence intervals,
weights, and pooled prevalence. Supports contour shading for prevalence ranges.
}
\examples{
dat <- data.frame(
  Study = c("Bazargani et al. 2015", "Nandhra et al. 2015", "Rai 2015", "Romano et al. 2011"),
  events = c(25, 109, 24, 9),
  n = c(454, 757, 380, 100)
)

forest_prev(
  dat = dat,
  title = "Prevalence Forest Plot",
  xlim = c(-25, 80),
  xpos_study = -12,
  xpos_events = -5,
  xpos_prev = 40,
  xpos_weight = 52,
  contour_breaks = c(0,5,10,25,35),
  contour_colors = c("gray90","gray70","gray50","gray30"),
  legend_title = "Prevalence (\%)"
)
}
