\name{es}
\alias{es}
\docType{data}
\title{
A BioConductor ExpressionSet Object Storing Gene Expression Data
}
\description{
A BioConductor ExpressionSet object storing gene expression data.
}
\usage{data("es")}
\format{
  The expression data are stored in a matrix, which contains
 55 row genes and 110 column subjects.

The phenotye data contains two variables: \code{sid} (subject ID)
and \code{grp} (case-control status). \code{grp=1} indicates the subject
is a case. \code{grp=0} indicates the subject is a control.

The feature data contains two variables: \code{geneid} (gene ID) and \code{memGenes}. \code{memGenes=1} indicates the gene is differentially correlated between cases and controls with
at least one other gene. \code{memGenes=0} indicates the gene is not diffferentially correlated with other genes.
}
\details{
The data contains 50 cases and 60 controls. The first 5 genes are differentially correlated with at least one other genes, while the remaining 50 genes are non-differentially correlated with other genes.

The covariance matrix of the first 5 genes in cases were generated by the function \code{rcorrmatrix} in R package \code{clusterGeneration}. The covariance matrix of the first 5 genes in controls are identical matrix.

The covariance matrix of the remaining 50 genes in cases
were generated by the function \code{rcorrmatrix}. The covariance matrix of the 50 genes in controls were the same as that in cases.

The first 50 subjects are cases. The remaining 60 subjects are controls.

}
%\source{
%%  ~~ reference to a publication or URL from which the data were obtained ~~
%}
\references{
Danyang Yu, Zeyu Zhang, Kimberly Glass, Jessica Su, Dawn L. DeMeo, Kelan Tantisira, Scott T. Weiss, Weiliang Qiu(corresponding author). New Statistical Methods for Constructing Robust Differential Correlation Networks to characterize the interactions among microRNAs. Scientific Reports 9, Article number: 3499 (2019)
}
\examples{
data(es)

print(es)

}
\keyword{datasets}
