% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{auto}
\alias{auto}
\title{Statistics of 1979 automobile models}
\format{
A data frame with 74 observations on the following 14 variables.
\describe{ 
\item{Model}{Make and model of car.}
\item{Origin}{a factor with levels A,E,J}
\item{Price}{Price in dollars.} 
\item{MPG}{Miles per gallon.} 
\item{Rep78}{Repair record for 1978 on 1 (worst) to 5 (best) scale.} 
\item{Rep77}{Repair record for 1978 on 1 to 5 scale.}
\item{Hroom}{Headroom in inches.} 
\item{Rseat}{Rear seat clearance in inches.} 
\item{Trunk}{Trunk volume in cubic feet.}
\item{Weight}{Weight in pounds.} 
\item{Length}{Length in inches.} 
\item{Turn}{Turning diameter in feet.}
\item{Displa}{Engine displacement in cubic inches.}
\item{Gratio}{Gear ratio for high gear.} 
}
}
\source{
This data frame was created from
http://euclid.psych.yorku.ca/ftp/sas/sssg/data/auto.sas
}
\usage{
auto
}
\description{
Statistics for 74 automobiles in the 1979 model year as sold in the US.
}
\details{
The data is from various sources, primarily \emph{Consumer Reports}, April,
1979, and the United States government EPA statistics on fuel consumption.
}
\examples{

corrgram(auto[, -c(1:2)])

}
\references{
Originally published in Chambers, Cleveland, Kleiner, and Tukey,
\emph{Graphical Methods for Data Analysis}, 1983, pages 352-355.
}
\keyword{datasets}
