% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomSearchRegr.R
\name{RandomSearchRegr}
\alias{RandomSearchRegr}
\title{Random Search for Regression Tasks}
\description{
RandomSearch randomly samples a population of candidates and returns non-dominated candidates w.r.t to the objectives
of MOC (Dandl et. al 2020) as counterfactuals. RandomSearch is equivalent to MOC with zero generations and the \code{random}
initialization strategy.

The four objectives of MOC (Dandl et. al 2020) to are:
\enumerate{
\item {Distance to \code{desired_prob} (classification tasks) or \code{desired_prob} (regression tasks).}
\item {Dissimilarity to \code{x_interest} measured by Gower's dissimilarity measure (Gower 1971).}
\item {Number of feature changes.}
\item {(Weighted) sum of dissimilarities to the \code{k} nearest data points in \code{predictor$data$X}.}
}
}
\details{
RandomSearch is typically used as a baseline in benchmark comparisons with MOC.
The total number of samples drawn is \code{mu} * \code{n_generations}. Using separate parameters \code{mu} and \code{n_generations}
is only required to make certain statistics comparable with MOC (e.g. the evolution of the dominated hypervolume).
}
\examples{
if (require("randomForest")) {
  # Train a model
  rf = randomForest(mpg ~ ., data = mtcars)
  # Create a predictor object
  predictor = iml::Predictor$new(rf)
  # Find counterfactuals for x_interest
  rs_regr = RandomSearchRegr$new(predictor, n_generations = 30L)
  cfactuals = rs_regr$find_counterfactuals(x_interest = mtcars[1L, ], desired_outcome = c(22, 26))
  # Print the counterfactuals
  cfactuals$data
  # Plot evolution of hypervolume and mean and minimum objective values 
  rs_regr$plot_statistics()
}

}
\references{
Dandl, S., Molnar, C., Binder, M., & Bischl, B. (2020).
"Multi-Objective Counterfactual Explanations". In: Parallel Problem
Solving from Nature – PPSN XVI, edited by Thomas Bäck, Mike Preuss,
André Deutz, Hao Wang, Carola Doerr, Michael Emmerich, and Heike Trautmann, 448–469,
Cham, Springer International Publishing, \doi{10.1007/978-3-030-58112-1_31}.

Deb, K., Pratap, A., Agarwal, S., & Meyarivan, T. A. M. T. (2002).
"A Fast and Elitist Multiobjective Genetic Algorithm: NSGA-II".
IEEE Transactions on Evolutionary Computation, 6(2), 182-197.

Goldstein, A., Kapelner, A., Bleich, J., & Pitkin, E. (2015).
"Peeking Inside the Black Box: Visualizing
Statistical Learning with Plots of Individual Conditional Expectation".
Journal of Computational and Graphical Statistics 24 (1): 44–65.
\doi{10.1080/10618600.2014.907095}.

Gower, J. C. (1971). "A General Coefficient of Similarity and Some of its Properties". Biometrics, 27, 623–637.

Hothorn, T., & Zeileis, A. (2017), "Transformation Forests".
Technical Report, \href{https://arxiv.org/abs/1701.02110}{arXiv 1701.02110}.

Li, Rui, L., Emmerich, M. T. M., Eggermont, J. Bäck, T., Schütz, M., Dijkstra, J., & Reiber, J. H. C. (2013).
"Mixed Integer Evolution Strategies for Parameter Optimization." Evolutionary Computation 21 (1): 29–64. \doi{10.1162/EVCO_a_00059}.
}
\section{Super classes}{
\code{\link[counterfactuals:CounterfactualMethod]{counterfactuals::CounterfactualMethod}} -> \code{\link[counterfactuals:CounterfactualMethodRegr]{counterfactuals::CounterfactualMethodRegr}} -> \code{RandomSearchRegr}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{optimizer}}{(\link[bbotk]{OptimInstanceBatchMultiCrit}) \cr
The object used for optimization.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RandomSearchRegr-new}{\code{RandomSearchRegr$new()}}
\item \href{#method-RandomSearchRegr-plot_statistics}{\code{RandomSearchRegr$plot_statistics()}}
\item \href{#method-RandomSearchRegr-get_dominated_hv}{\code{RandomSearchRegr$get_dominated_hv()}}
\item \href{#method-RandomSearchRegr-plot_search}{\code{RandomSearchRegr$plot_search()}}
\item \href{#method-RandomSearchRegr-clone}{\code{RandomSearchRegr$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethod" data-id="print"><a href='../../counterfactuals/html/CounterfactualMethod.html#method-CounterfactualMethod-print'><code>counterfactuals::CounterfactualMethod$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethodRegr" data-id="find_counterfactuals"><a href='../../counterfactuals/html/CounterfactualMethodRegr.html#method-CounterfactualMethodRegr-find_counterfactuals'><code>counterfactuals::CounterfactualMethodRegr$find_counterfactuals()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomSearchRegr-new"></a>}}
\if{latex}{\out{\hypertarget{method-RandomSearchRegr-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{RandomSearchRegr} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomSearchRegr$new(
  predictor,
  fixed_features = NULL,
  max_changed = NULL,
  mu = 20L,
  n_generations = 175L,
  p_use_orig = 0.5,
  k = 1L,
  weights = NULL,
  lower = NULL,
  upper = NULL,
  distance_function = "gower"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{(\link[iml]{Predictor})\cr
The object (created with \code{iml::Predictor$new()}) holding the machine learning model and the data.}

\item{\code{fixed_features}}{(\code{character()} | \code{NULL})\cr
Names of features that are not allowed to be changed. \code{NULL} (default) allows all features to be changed.}

\item{\code{max_changed}}{(\code{integerish(1)} | \code{NULL})\cr
Maximum number of feature changes. \code{NULL} (default) allows any number of changes.}

\item{\code{mu}}{(\code{integerish(1)})\cr
The population size. Default is \code{20L}. The total number of random samples is set to \code{mu * n_generations}.
See the \code{Details} section for further details.}

\item{\code{n_generations}}{(\code{integerish(1)})\cr
The number of generations. Default is \code{175L}. The total number of random samples is set to \code{mu * n_generations}.
See the \code{Details} section for further details.}

\item{\code{p_use_orig}}{(\code{numeric(1)})\cr
Probability with which a feature/gene is reset to its original value in \code{x_interest} after random sampling. Default is \code{0.5}.}

\item{\code{k}}{(\code{integerish(1)})\cr
The number of data points to use for the forth objective. Default is \code{1L}.}

\item{\code{weights}}{(\code{numeric(1) | numeric(k)} | \code{NULL})\cr
The weights used to compute the weighted sum of dissimilarities for the forth objective. It is either a single value
or a vector of length \code{k}. If it has length \code{k}, the i-th element specifies the weight of the i-th closest data point.
The values should sum up to \code{1}. \code{NULL} (default) means all data points are weighted equally.}

\item{\code{lower}}{(\code{numeric()} | \code{NULL})\cr
Vector of minimum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{lower} is taken as its minimum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{upper}}{(\code{numeric()} | \code{NULL})\cr
Vector of maximum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{upper} is taken as its maximum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{distance_function}}{(\verb{function()} | \code{'gower'} | \code{'gower_c'})\cr
The distance function to be used in the second and fourth objective.
Either the name of an already implemented distance function
('gower' or 'gower_c') or a function.
If set to 'gower' (default), then Gower's distance (Gower 1971) is used;
if set to 'gower_c', a C-based more efficient version of Gower's distance is used.
A function must have three arguments  \code{x}, \code{y}, and \code{data} and should
return a \code{double} matrix with \code{nrow(x)} rows and maximum \code{nrow(y)} columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomSearchRegr-plot_statistics"></a>}}
\if{latex}{\out{\hypertarget{method-RandomSearchRegr-plot_statistics}{}}}
\subsection{Method \code{plot_statistics()}}{
Plots the evolution of the mean and minimum objective values together with the dominated hypervolume over
the generations. All values for a generation are computed based on all non-dominated individuals that emerged until
that generation. The randomly drawn samples are therefore split into \code{n_generations} folds of size \code{mu.}
This function mimics MOCs \code{plot_statistics()} method. See the \code{Details} section for further information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomSearchRegr$plot_statistics(centered_obj = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{centered_obj}}{(\code{logical(1)})\cr
Should the objective values be centered? If set to \code{FALSE}, each objective value is visualized in a separate plot,
since they (usually) have different scales. If set to \code{TRUE} (default), they are visualized in a single plot.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomSearchRegr-get_dominated_hv"></a>}}
\if{latex}{\out{\hypertarget{method-RandomSearchRegr-get_dominated_hv}{}}}
\subsection{Method \code{get_dominated_hv()}}{
Calculates the dominated hypervolume of each generation. The randomly drawn samples are therefore split
into \code{n_generations} folds of size \code{mu.}
This function mimics MOCs \code{get_dominated_hv()} method. See the \code{Details} section for further information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomSearchRegr$get_dominated_hv()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.table} with the dominated hypervolume of each generation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomSearchRegr-plot_search"></a>}}
\if{latex}{\out{\hypertarget{method-RandomSearchRegr-plot_search}{}}}
\subsection{Method \code{plot_search()}}{
Visualizes two selected objective values of all emerged individuals in a scatter plot.
The randomly drawn samples are therefore split into \code{n_generations} folds of size \code{mu.}
This function mimics MOCs \code{plot_search()} method. See the \code{Details} section for further information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomSearchRegr$plot_search(objectives = c("dist_target", "dist_x_interest"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{objectives}}{(\code{character(2)})\cr
The two objectives to be shown in the plot. Possible values are "dist_target", "dist_x_interest, "no_changed",
and "dist_train".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomSearchRegr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RandomSearchRegr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomSearchRegr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
