% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WhatIfClassif.R
\name{WhatIfClassif}
\alias{WhatIfClassif}
\title{WhatIf for Classification Tasks}
\description{
WhatIf returns the \code{n_counterfactual} most similar observations to \code{x_interest} from observations in \code{predictor$data$X}
whose prediction for the \code{desired_class} is in the \code{desired_prob} interval.
}
\details{
By default, the dissimilarities are computed using Gower's dissimilarity measure (Gower 1971). \cr
Only observations whose features values lie between the corresponding values in \code{lower} and \code{upper} are considered
counterfactual candidates.
}
\examples{
if (require("randomForest")) {
  # Train a model
  rf = randomForest(Species ~ ., data = iris)
  # Create a predictor object
  predictor = iml::Predictor$new(rf, type = "prob")
  # Find counterfactuals for x_interest
  wi_classif = WhatIfClassif$new(predictor, n_counterfactuals = 5L)
  cfactuals = wi_classif$find_counterfactuals(
    x_interest = iris[150L, ], desired_class = "versicolor", desired_prob = c(0.5, 1)
  )
  # Print the results
  cfactuals$data
}

}
\references{
Gower, J. C. (1971). "A General Coefficient of Similarity and Some of its Properties". Biometrics, 27, 623–637.

Wexler, J., Pushkarna, M., Bolukbasi, T., Wattenberg, M., Viégas, F., & Wilson, J. (2019). "The What-If tool:
Interactive Probing of Machine Learning Models". IEEE Transactions on Visualization and Computer Graphics, 26(1), 56–65.
}
\section{Super classes}{
\code{\link[counterfactuals:CounterfactualMethod]{counterfactuals::CounterfactualMethod}} -> \code{\link[counterfactuals:CounterfactualMethodClassif]{counterfactuals::CounterfactualMethodClassif}} -> \code{WhatIfClassif}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WhatIfClassif-new}{\code{WhatIfClassif$new()}}
\item \href{#method-WhatIfClassif-clone}{\code{WhatIfClassif$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethod" data-id="print"><a href='../../counterfactuals/html/CounterfactualMethod.html#method-CounterfactualMethod-print'><code>counterfactuals::CounterfactualMethod$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethodClassif" data-id="find_counterfactuals"><a href='../../counterfactuals/html/CounterfactualMethodClassif.html#method-CounterfactualMethodClassif-find_counterfactuals'><code>counterfactuals::CounterfactualMethodClassif$find_counterfactuals()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WhatIfClassif-new"></a>}}
\if{latex}{\out{\hypertarget{method-WhatIfClassif-new}{}}}
\subsection{Method \code{new()}}{
Create a new WhatIfClassif object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WhatIfClassif$new(
  predictor,
  n_counterfactuals = 1L,
  lower = NULL,
  upper = NULL,
  distance_function = "gower"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{(\link[iml]{Predictor})\cr
The object (created with \code{iml::Predictor$new()}) holding the machine learning model and the data.}

\item{\code{n_counterfactuals}}{(\code{integerish(1)})\cr
The number of counterfactuals to return. Default is \code{1L}.}

\item{\code{lower}}{(\code{numeric()} | \code{NULL})\cr
Vector of minimum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{lower} is taken as its minimum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{upper}}{(\code{numeric()} | \code{NULL})\cr
Vector of maximum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{upper} is taken as its maximum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{distance_function}}{(\verb{function()} | \code{'gower'} | \code{'gower_c'})\cr
The distance function used to compute the distances between \code{x_interest}
and the training data points for finding \code{x_nn}.
Either the name of an already implemented distance function
('gower' or 'gower_c') or a function.
If set to 'gower' (default), then Gower's distance (Gower 1971) is used;
if set to 'gower_c', a C-based more efficient version of Gower's distance is used.
A function must have three arguments  \code{x}, \code{y}, and \code{data} and should
return a \code{double} matrix with \code{nrow(x)} rows and maximum \code{nrow(y)} columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WhatIfClassif-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WhatIfClassif-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WhatIfClassif$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
