% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap_solve.R
\name{lap_solve}
\alias{lap_solve}
\title{Solve linear assignment problems}
\usage{
lap_solve(
  x,
  source = NULL,
  target = NULL,
  cost = NULL,
  maximize = FALSE,
  method = "auto",
  forbidden = NA
)
}
\arguments{
\item{x}{Cost matrix, data frame, or tibble. If a data frame/tibble,
must include columns specified by \code{source}, \code{target}, and \code{cost}.}

\item{source}{Column name for source/row indices (if \code{x} is a data frame)}

\item{target}{Column name for target/column indices (if \code{x} is a data frame)}

\item{cost}{Column name for costs (if \code{x} is a data frame)}

\item{maximize}{Logical; if TRUE, maximizes total cost instead of minimizing (default: FALSE)}

\item{method}{Algorithm to use. One of:
\itemize{
\item "auto" (default): automatically selects best algorithm
\item "jv": 'Jonker-Volgenant' algorithm (general purpose, fast)
\item "hungarian": Classic 'Hungarian' algorithm
\item "auction": 'Bertsekas' auction algorithm (good for large dense problems)
\item "sap": Sparse assignment (good for sparse/rectangular problems)
\item "hk01": 'Hopcroft-Karp' for binary/uniform costs
}}

\item{forbidden}{Value to mark forbidden assignments (default: NA). Can also use Inf.}
}
\value{
A tibble with columns:
\itemize{
\item \code{source}: row/source indices
\item \code{target}: column/target indices
\item \code{cost}: cost of each assignment
\item \code{total_cost}: total cost (attribute)
}
}
\description{
Provides a tidy interface for solving the linear assignment problem using
'Hungarian' or 'Jonker-Volgenant' algorithms. Supports rectangular matrices,
NA/Inf masking, and data frame inputs.
}
\examples{
# Matrix input
cost <- matrix(c(4, 2, 5, 3, 3, 6, 7, 5, 4), nrow = 3)
lap_solve(cost)

# Data frame input
library(dplyr)
df <- tibble(
  source = rep(1:3, each = 3),
  target = rep(1:3, times = 3),
  cost = c(4, 2, 5, 3, 3, 6, 7, 5, 4)
)
lap_solve(df, source, target, cost)

# With NA masking (forbidden assignments)
cost[1, 3] <- NA
lap_solve(cost)

# Grouped data frames
df <- tibble(
  sim = rep(1:2, each = 9),
  source = rep(1:3, times = 6),
  target = rep(1:3, each = 3, times = 2),
  cost = runif(18, 1, 10)
)
df |> group_by(sim) |> lap_solve(source, target, cost)

}
