% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solana.R
\name{solana_get_signature_for_address}
\alias{solana_get_signature_for_address}
\title{solana_get_signature_for_address}
\usage{
solana_get_signature_for_address(
  url,
  address,
  limit = NULL,
  timeout_seconds = 60
)
}
\arguments{
\item{url}{the RPC url for your API call}

\item{address}{the address for which you're retrieving signatures}

\item{limit}{maximum transaction signatures to return (between 1 and 1,000).
Default is 1,000.}

\item{timeout_seconds}{seconds until the query times out. Default is 60.}
}
\value{
Returns signatures for confirmed transactions that include the given
address in their accountKeys list. Returns signatures backwards in time from
the provided signature or most recent confirmed block
}
\description{
solana_get_signature_for_address
}
\examples{
\donttest{
url <- "https://api.devnet.solana.com"
address <- "Vote111111111111111111111111111111111111111"
data <- solana_get_signature_for_address(url,address)}
}
