% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_current_price.R
\name{get_current_price}
\alias{get_current_price}
\title{Get current price of cryptocurrencies}
\usage{
get_current_price(pair, exchange = "kraken", api_key = NULL, allowance = FALSE)
}
\arguments{
\item{pair}{A string containing a pair symbol, e.g. \emph{btcusd} (required argument). Run \code{get_pairs()} to find other available pairs.}

\item{exchange}{A string containing the exchange. Default is \emph{kraken}. Run \code{get_exchanges()} to find other available exchanges.}

\item{api_key}{A string containing the API key. See \url{https://docs.cryptowat.ch/rest-api/rate-limit} to learn how to create an account and how to generate an API key.}

\item{allowance}{A logical (default is \code{FALSE}). If \code{TRUE} the function returns a list which includes allowance information, i.e. cost of the request, remaining credits and your account name.}
}
\value{
Current price of a given pair of currencies. If allowance is \code{TRUE}, \code{get_current_price()} returns a list.
}
\description{
Get current price of cryptocurrencies using the REST API of cryptowat.ch. The route is \emph{price} or \emph{prices} and returns the current price of a given pair or current prices of all pairs. See \url{https://docs.cryptowat.ch/rest-api/markets/price} for further information.
}
\examples{
\dontrun{
# Daily prices of Bitcoin in USD
current.price <- get_current_price("btcusd")
current.prices <- get_current_price()
}
}
\references{
See \url{https://docs.cryptowat.ch/rest-api} for further information.
}
\seealso{
\code{\link{get_markets}}, \code{\link{get_ohlc}}, \code{\link{get_exchanges}}, \code{\link{get_pairs}}
}
