% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.input_data.R
\name{read_sampleTable}
\alias{read_sampleTable}
\title{Read sample table}
\usage{
read_sampleTable(file, system = NULL, file.location = ".")
}
\arguments{
\item{file}{character. The name or the path of csv file to be read. If it
does not contain an absolute path, the file name is relative to the current
working directory, (\code{\link[base]{getwd}}).}

\item{system}{character. The name of digital PCR system used to generate
the data. It must be either Thermo Fisher or Bio-Rad. Abbreviations are
also accepted.}

\item{file.location}{character. Full path name to reference and sample
files location. The default corresponds to the working directory,
(\code{\link[base]{getwd}}). Tilde expansion (see
(\code{\link[base]{path.expand}})) is performed.}
}
\value{
An object of class \code{sample_table}.
}
\description{
This function reads a file containing the essential information about the
samples and experimental settings. The file has to be filled out by the user
and formatted as described in the vignette.
}
\examples{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata", package = "dPCP")

#Read sample table file
sample.table <- read_sampleTable(sampleTable, system = "bio-rad",
                                 file.location = fileLoc)
}
