% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_dri_llm_prompts.R
\name{make_dri_llm_prompts}
\alias{make_dri_llm_prompts}
\title{Make DRI LLM Prompts}
\usage{
make_dri_llm_prompts(
  dri_survey,
  role_info = list(uid = NA_character_, role = NA_character_, description =
    NA_character_)
)
}
\arguments{
\item{dri_survey}{a list of formatted DRI survey questions}

\item{role_info}{information about a specific role, including unique
identifier \code{uid}, \code{role} name, and role \code{description}}
}
\value{
a list of lists with four variables: \code{system},
\code{considerations}, \code{policies}, and \code{reason} prompts
}
\description{
\code{make_dri_llm_prompts} creates the system and user prompts used for
generating LLM DRI survey data
}
\examples{

# get ccps as an example survey
dri_survey <- format_dri_survey(surveys[surveys$name == "ccps",])

# create an example role from scratch
role_info <- list(
  uid = "sur",
  role = "surfer",
  description = "likes the ocean"
)

make_dri_llm_prompts(dri_survey, role_info)

}
\seealso{
\code{\link[=format_dri_survey]{format_dri_survey()}} for how to format \code{dri_survey}

\link{prompts} for how prompts are formatted

Other LLM methods: 
\code{\link{get_dri_llm_response}()},
\code{\link{get_model_ids}()}
}
\concept{LLM methods}
